/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.TextArea;
import java.awt.Event;
import java.awt.Label;
import dejava.sys.DejavaProperties;

public class CodeArea extends TextArea implements Runnable {
    Label blinkLabel = null;	// for Solaris bugs (no cursor blink)
    Thread blinkThread = null;

    public CodeArea() {
	super();
	setFont();
    }

    public CodeArea(int rows, int cols) {
	super(rows, cols);
	setFont();
    }

    public CodeArea(String code) {
	super(code);
	setFont();
    }

    public CodeArea(String code, int rows, int cols) {
	super(code, rows, cols);
	setFont();
    }

    private void setFont() {
	setFont(DejavaProperties.getFont("font.code"));
    }

    void setBlink(Label blinkLabel) {
	this.blinkLabel = blinkLabel;
    }

    public boolean handleEvent(Event ev) {
	if (blinkLabel != null) {
	    if (ev.id == Event.GOT_FOCUS) {
		if (blinkThread == null && isEditable()) {
		    blinkThread = new Thread(this);
		    blinkThread.start();
		}
	    } else if (ev.id == Event.LOST_FOCUS) {
		if (blinkThread != null && blinkThread.isAlive()) {
		    blinkThread.stop();
		}
		blinkThread = null;
	    }
	}
	return super.handleEvent(ev);
    }

    public void run()  {
	int i = 0;
	while (blinkThread != null) {
	    blinkLabel.setText((i++ & 1) == 0 ? " " : "\t");
	    try {
		Thread.sleep(600);
	    } catch (InterruptedException e) {
	    }
	}
    }
}
