/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import java.lang.String;
import java.awt.TextArea;
import java.awt.Window;
import dejava.sys.DejavaProperties;

public
class CodeView extends CodeArea {
    private String original = null;

    /**
     * the constructor
     */
    CodeView(int cols, int rows) {
        super(cols, rows);
    }

    public void setEditable(boolean editable) {
	if (isEditable() != editable) {
	    super.setEditable(editable);
	}
    }

    /**
     * get code
     */
    public String getCode() {
	return getText();
    }

    /**
     * set new code
     */
    public void setCode(String code) {
	setText(code);
	original = getCode();
    }

    /**
     * reset text, set original text once more
     */
    void resetCode() {
	setText(original);
    }

    /**
     * returns whether this code is changed or not
     */
    boolean isChanged() {
	return (isEditable() && !getText().equals(original));
    }

    /**
     * replace code
     */
    void replaceCode(String code) {
	setText(code);
    }

    /**
     * replace original text
     */
    void replaceOriginal(String code) {
	original = code;
    }

    void setCursorPos(int pos) {
	select(pos, pos);
	requestFocus();
    }

    int cursorPos() {
	return getSelectionStart();
    }
}
