/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.io.File;
import dejava.sys.*;
import dejava.util.Compile;

class CompileMenuBar extends CommandMenuBar {

    protected static final String MENU_RECOMPILE = "recompile";

    protected boolean createFileCommandMenu(DejavaMenu menu) {
	//super.createFileCommandMenu(menu);
	menu.add(MENU_STOP);
        menu.add(MENU_RECOMPILE);
	return true;
    }

    protected void actionFileMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_RECOMPILE)) {
	    ((CompileFrame)frame).restart();
        } else {
	    super.actionFileMenu(label, frame, cp);
	}
    }

    protected void actionClassMenu(String label, DejavaFrame frame, CodePath cp) {
	if (cp.classManager() == null) cp = ((CompileFrame)frame).getExecuteCodePath();
	super.actionClassMenu(label, frame, cp);
    }

    protected void updateExecuteMenuActivity(CodePath cp) {
	DejavaMenu menu = classMenu;
	ClassManager cm = cp.classManager();
	if (cm != null) {
	    File sourceFile = new File(cp.sourceFileManager().absolutePath());
	    String cf = sourceFile.getParent() + File.separator + cm.name() + ".class";
	    File classFile = new File(cf);
	    if (!classFile.exists()) return;
	    if (sourceFile.lastModified() > classFile.lastModified()) return;
	    if (Compile.canExecute) {
		menu.enable(MENU_COMPILE);
	    }
	    if (ClassManager.canExecute) {
		if (cm.hasMainMethod()) {
		    menu.enable(MENU_EXECUTE);
		    menu.enable(MENU_EXECUTE_WITH_ARGS);
		}
		if (cm.isApplet()) {
		    menu.enable(MENU_EXECUTE);
		    menu.enable(MENU_EXECUTE_WITH_ARGS);
		    menu.enable(MENU_EXECUTE_WITH_HTML);
		}
	    }
	}
    }
}
