/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import dejava.util.*;
import java.io.File;
import java.awt.*;

public class DejavaDialog extends FocusDialog {
    protected static final String NORTH  = "North";
    protected static final String EAST   = "East";
    protected static final String SOUTH  = "South";
    protected static final String WEST   = "West";
    protected static final String CENTER = "Center";

    public static final String OK     = "Ok";
    public static final String CANCEL = "Cancel";

    private TextField textField;
    private Button leftButton;
    private Button middleButton;
    private Button rightButton;

    private int choosenButton;
    public static final int NONE   = 0;
    public static final int LEFT   = 1;
    public static final int MIDDLE = 2;
    public static final int RIGHT  = 3;

    private Thread suspendThread = null;

    DejavaDialog(Frame f, boolean modal) {
	super(f, modal);
    }

    protected DejavaDialog(Frame f, String msg) {
	this(f, msg, null, OK, null, CANCEL);
    }

    protected DejavaDialog(Frame f, String msg, String text) {
	this(f, msg, text, OK, null, CANCEL);
    }

    protected DejavaDialog(Frame f, String msg, String btn1, String btn2) {
	this(f, msg, null, btn1, null, btn2);
    }

    DejavaDialog(Frame f, String msg, String text,
		 String left, String middle, String right) {
	super(f, true);
	setBackground(Color.lightGray);

	// create message
	Panel message;
	if (msg == null) {
	    message = null;
	} else {
	    message = new Panel();
	    msg = msg.trim();
	    int lines = 1;
	    int lf = 0;
	    while ((lf = msg.indexOf('\n', lf) + 1) > 0) {
		lines++;
	    }
	    if (lines == 1) {
		message.add(new Label(msg));
	    } else {
		Panel messages = new Panel();
		messages.setLayout(new GridLayout(lines, 1));
		int from = 0;
		while ((lf = msg.indexOf('\n', from)) >= from) {
		    messages.add(new Label(msg.substring(from, lf)));
		    from = lf + 1;
		}
		messages.add(new Label(msg.substring(from)));
		message.add(messages);
	    }
	}

	// create requesting text field
	if (text == null) {
	    textField = null;
	} else {
	    textField = new TextField(text, Math.max(30, text.length()));
	}

	// create buttons
	Panel buttons = new Panel();
	buttons.setLayout(new BorderLayout());
	if (left != null) {
	    Panel leftArea = new Panel();
	    leftArea.add(CENTER, leftButton = new DejavaButton(left));
	    buttons.add(WEST, leftArea);
	}
	if (middle != null) {
	    Panel middleArea = new Panel();
	    middleArea.add(CENTER, middleButton = new DejavaButton(middle));
	    buttons.add(CENTER, middleArea);
	}
	if (right != null) {
	    Panel rightArea = new Panel();
	    rightArea.add(CENTER, rightButton = new DejavaButton(right));
	    buttons.add(EAST, rightArea);
	}

	// layout display items
	if (message   != null) add(NORTH, message);
	if (textField != null) add(CENTER, textField);
	add(SOUTH, buttons);
    }

    public int choose() {
	choosenButton = NONE;
	show();
	suspend();
	return choosenButton;
    }

    public boolean confirm() {
	return choose() == LEFT;
    }

    public void hide() {
	resume();
	super.hide();
    }

    private void suspend() {
	suspendThread = Thread.currentThread();
	suspendThread.suspend();
    }

    private synchronized void resume() {
	if (suspendThread != null) {
	    suspendThread.resume();
	    suspendThread = null;
	}
    }

    public boolean handleEvent(Event ev) {
	if (ev.id == Event.WINDOW_DESTROY) {
	    if (rightButton != null) {
		actionRightButton();
		return true;
	    } else if (middleButton != null) {
		actionMiddleButton();
		return true;
	    }
	}
	return super.handleEvent(ev);
    }

    public boolean action(Event ev, Object arg) {
	if (ev.target == leftButton) {
	    actionLeftButton();
	} else if (ev.target == middleButton) {
	    actionMiddleButton();
	} else if (ev.target == rightButton) {
	    actionRightButton();
	} else if (ev.target == textField) {
	    actionLeftButton();
	    return false;
	} else {
	    return false;
	}
	return true;
    }

    public boolean keyDown(Event ev, int keycode) {
	if (ev.target == textField) {
	    if (keycode == '\n' || keycode == '\r') {
		if (ev.shiftDown()) {
		    actionMiddleButton();
		} else {
		    actionLeftButton();
		}
		return true;
	    } else if (keycode == '\033') {
		actionRightButton();
		return true;
	    }
	}
	return super.keyDown(ev, keycode);
    }

    public void actionLeftButton() {
	choosenButton = LEFT;
	hide();
    }

    public void actionMiddleButton() {
	choosenButton = MIDDLE;
	hide();
    }

    public void actionRightButton() {
	choosenButton = RIGHT;
	hide();
    }

    public int choosenButton() {
	return choosenButton;
    }

    public String getText() {
	return textField == null ? null : textField.getText();
    }

    public static
    boolean confirm(Frame f, String msg) {
	return confirm(f, msg, OK, CANCEL);
    }

    public static
    boolean confirm(Frame f, String msg, String label) {
	return confirm(f, msg, label, CANCEL);
    }

    public static
    boolean confirm(Frame f, String msg, String label1, String label2) {
	DejavaDialog dialog = new DejavaDialog(f, msg, label1, label2);
	boolean accept = dialog.confirm();
	dialog.dispose();
	return accept;
    }

    public static void information(Frame f, String msg) {
	information(f, msg, OK);
    }

    public static void information(Frame f, String msg, String btnLabel) {
	DejavaDialog dialog = new DejavaDialog(f, msg, null, null, btnLabel, null);
	dialog.confirm();
	dialog.dispose();
    }

    public static
    String request(Frame f, String msg) {
	return request(f, msg, null);
    }

    public static
    String request(Frame f, String msg, String init) {
	
	DejavaDialog dialog = new DejavaDialog(f, msg, (init == null ? "" : init));
	boolean accept = dialog.confirm();
	String text = dialog.getText().trim();
	dialog.dispose();
	return (accept && text.length() > 0) ? text : null;
    }

    public static
    int choose(Frame f, String msg, String btn1, String btn2, String btn3) {
	
	DejavaDialog dialog = new DejavaDialog(f, msg, null, btn1, btn2, btn3);
	int chosen = dialog.choose();
	dialog.dispose();
	return chosen;
    }
}
