/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.*;
import java.util.Enumeration;
import dejava.sys.SystemManager;
import dejava.sys.DejavaProperties;

public class DejavaList extends List {
    Panel panel = null;

    public DejavaList() {
	super();
    }

    public DejavaList(int rows, boolean multipleSelections) {
	super(rows, multipleSelections);
	setFont(DejavaProperties.getFont("font.list"));
    }

    public Panel makePanel() {
	panel = new Panel();
	panel.setLayout(new BorderLayout());
	panel.add("Center", this);
	return panel;
    }

    public synchronized void clear() {
	if (SystemManager.onWin32) {
	    delItems(0, countItems() - 1);
	} else {
	    super.clear();
	}
	if (panel != null && SystemManager.onSolaris) {
	    addItem(""); // to clear horizontal scroll bar
	    super.clear();
	    reshape();
	}
    }

    public void reshape() {
	if (panel != null && SystemManager.onSolaris) {
	    Dimension size = panel.size();
	    resize(size.width, size.height + 1);
	    resize(size);
	}
    }

    synchronized void selectAndVisible(int select) {
	int selected = getSelectedIndex();
	if (select < 0) {
	    if (selected >= 0) deselect(selected);
	} else {
	    if (selected != select) select(select);
	    int rows = getRows() - 1;
	    int half = rows / 2;
	    int visibleIndex = getVisibleIndex();
	    if (SystemManager.onWin32) {
		if (visibleIndex <0) visibleIndex = 0;
		if (select <= visibleIndex || select >= visibleIndex + rows) {
		    makeVisible(Math.max(select - half, 0));
		}	
	    } else {
		if (visibleIndex < rows) visibleIndex = rows;
		if (select <= visibleIndex - rows || select >= visibleIndex) {
		    makeVisible(Math.min(select + half, countItems() - 1));
		}
	    }
	}
    }

    synchronized boolean selectItemIfSameList(Enumeration en, String name) {
	int num = countItems();
	for (int i = 0; i < num; i++) {
	    if (!en.hasMoreElements()) return false;
	    String listedName = getItem(i);
	    if (!listedName.equals((String)en.nextElement())) return false;
	    if (listedName.equals(name)) {
		if (!isSelected(i)) selectAndVisible(i);
	    } else {
		if (isSelected(i)) deselect(i);
	    }
	}
	return !en.hasMoreElements();
    }

    synchronized int listAndSelectItem(Enumeration en, String selectName) {
	clear();
	int select = -1;
	for (int i = 0; en.hasMoreElements(); i++) {
	    String name = (String)en.nextElement();
	    addItem(name);
	    if (name.equals(selectName)) select = i;
	}
	reshape();
	if (select >= 0) selectAndVisible(select);
	return select;
    }
}
