/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osam Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.*;
import dejava.sys.DejavaProperties;

class DejavaMenu extends Menu {

    public DejavaMenu(String label) {
	this(label, false);
    }

    public DejavaMenu(String label, boolean tearOff) {
	super(label, tearOff);
	setFont(DejavaProperties.getFont("font.menu"));
    }

    public void add(String label) {
	add(new DejavaMenuItem(label));
    }

    CheckboxMenuItem addCheckboxItem(String label) {
	CheckboxMenuItem item = new CheckboxMenuItem(label);
	item.setFont(DejavaProperties.getFont("font.menu"));
	//item.setState(true);
	add(item);
	return item;
    }

    int indexOf(String label) {
	for (int i = countItems(); --i >= 0; ) {
	    MenuItem item = getItem(i);
	    if (item.getLabel().equals(label)) {
		return i;
	    }
	}
	return -1;
    }

    MenuItem getItem(String label) {
	for (int i = countItems(); --i >= 0; ) {
	    MenuItem item = getItem(i);
	    if (item.getLabel().equals(label)) {
		return item;
	    }
	}
	return null;
    }

    boolean getState(String label) {
	MenuItem item = getItem(label);
	if (item != null && (item instanceof CheckboxMenuItem)) {
	    return ((CheckboxMenuItem)item).getState();
	} else {
	    return false;
	}
    }

    void enable(String label) {
	MenuItem item = getItem(label);
	if (item != null) {
	    item.enable();
	} else {
	    System.err.println("BUG: Could not enable MenuItem: " + label);
	}
    }

    void disable(String label) {
	MenuItem item = getItem(label);
	if (item != null) {
	    item.disable();
	} else {
	    System.err.println("BUG: Could not disable MenuItem: " + label);
	}
    }

    synchronized void clear() {
	for (int i = countItems(); --i >= 0; ) {
	    remove(i);
	}
    }
}
