/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import dejava.util.*;
import dejava.lang.*;
import java.util.Enumeration;
import java.io.File;
import java.awt.*;

class DejavaMenuBar extends MenuBar {

    protected DejavaMenu fileMenu;
    protected DejavaMenu editMenu;
    protected DejavaMenu optionMenu;
    protected DejavaMenu projectMenu;
    protected DejavaMenu packageMenu;
    protected DejavaMenu classMenu;
    protected DejavaMenu methodMenu;
    protected DejavaMessagesMenu messagesMenu;

    protected static final String MENU_FILE    = "File";
    protected static final String MENU_EDIT    = "Edit";
    protected static final String MENU_OPTION  = "Option";
    protected static final String MENU_PROJECT = "Project";
    protected static final String MENU_PACKAGE = "Package";
    protected static final String MENU_CLASS   = "Class";
    protected static final String MENU_METHOD  = "Method";

    protected final static String MENU_BEGINNING_OF_BLOCK = "beginning of block";
    protected final static String MENU_COMPILE            = "compile";
    protected final static String MENU_COMPILE_UPDATED    = "compile updated sources";
    protected final static String MENU_COPY               = "copy";
    protected final static String MENU_CUT                = "cut";
    protected final static String MENU_END_OF_BLOCK       = "end of block";
    protected final static String MENU_EXECUTE_WITH_ARGS  = "execute with args";
    protected final static String MENU_EXECUTE_WITH_HTML  = "execute with HTML";
    protected final static String MENU_EXECUTE            = "execute";
    protected final static String MENU_GREP               = "grep";
    protected final static String MENU_HIERARCHY          = "hierarchy";
    protected final static String MENU_IMPLEMENTERS       = "implementers";
    protected final static String MENU_PASTE              = "paste";
    protected final static String MENU_QUIT               = "close";
    protected final static String MENU_RAISE_TRANSCRIPT	  = "raise transcript";
    protected final static String MENU_REBUILD_DATABASE   = "rebuild database";
    protected final static String MENU_SEARCH_REPLACE     = "search/replace";
    protected final static String MENU_SENDERS            = "senders";
    protected final static String MENU_SELECT_BLOCK       = "select block";
    protected final static String MENU_SET_SHIFT_WIDTH    = "set shift width";
    protected final static String MENU_SHIFT_BLOCK_RIGHT  = "shift block right {>>}";
    protected final static String MENU_SHIFT_BLOCK_LEFT   = "shift block left  {<<}";
    protected final static String MENU_SHIFT_LINE_RIGHT   = "shift lines right  >>";
    protected final static String MENU_SHIFT_LINE_LEFT    = "shift lines left   <<";
    protected final static String MENU_SPAWN_PROJECT	  = "spawn ";
    protected final static String MENU_SPAWN              = "spawn";
    protected final static String MENU_SYNC_DATABASE      = "sync database";
    protected final static String MENU_SYNC               = "sync";
    protected final static String MENU_USERS              = "users";
    protected final static String MENU_MESSAGES           = "messages";

    TextArea editArea = null;
    Replacer replacer = null;

    private static String buffer = new String();

    public DejavaMenuBar() {
	super();
	setFont(DejavaProperties.getFont("font.menu"));

	fileMenu     = createFileMenu();
	editMenu     = createEditMenu();
	optionMenu   = createOptionMenu();
	projectMenu  = createProjectMenu();
	packageMenu  = createPackageMenu();
	classMenu    = createClassMenu();
	methodMenu   = createMethodMenu();

	if (fileMenu     != null) add(fileMenu);
	if (editMenu     != null) add(editMenu);
	if (optionMenu   != null) add(optionMenu);
	if (projectMenu  != null) add(projectMenu);
	if (packageMenu  != null) add(packageMenu);
	if (classMenu    != null) add(classMenu);
	if (methodMenu   != null) add(methodMenu);
    }

    public void close() {
	if (replacer != null) {
	    replacer.hide();
	    replacer.dispose();
	    replacer = null;
	}
    }

    void setEditArea(TextArea textArea) {
	editArea = textArea;
    }

    /**
     * update Menu activity
     */
    public void updateActivity(DejavaFrame frame, CodePath cp) {
	if (   fileMenu != null)    updateFileMenuActivity(   fileMenu, frame, cp);
	if (   editMenu != null)    updateEditMenuActivity(   editMenu, frame, cp);
	if ( optionMenu != null)  updateOptionMenuActivity( optionMenu, frame, cp);
	if (projectMenu != null) updateProjectMenuActivity(projectMenu, frame, cp);
	if (packageMenu != null) updatePackageMenuActivity(packageMenu, frame, cp);
	if (  classMenu != null)   updateClassMenuActivity(  classMenu, frame, cp);
	if ( methodMenu != null)  updateMethodMenuActivity( methodMenu, frame, cp);
    }

    boolean action(Event e, Object arg, DejavaFrame frame, CodePath cp)
					throws DejavaClassNotFoundException {
	if (e.target instanceof MenuItem) {
	    int saveCursor = frame.getCursorType();
	    frame.setCursor(Frame.WAIT_CURSOR);
	    frame.getToolkit().sync();
	    boolean done = true;
	    Menu menu = (Menu)(((MenuItem)e.target).getParent());
	    String label = (String)arg;
		 if (menu ==     fileMenu)      actionFileMenu(label, frame, cp);
	    else if (menu ==     editMenu)      actionEditMenu(label, frame, cp);
	    else if (menu ==   optionMenu)    actionOptionMenu(label, frame, cp);
	    else if (menu ==  projectMenu)   actionProjectMenu(label, frame, cp.projectCodePath());
	    else if (menu ==  packageMenu)   actionPackageMenu(label, frame, cp.packageCodePath());
	    else if (menu ==    classMenu)     actionClassMenu(label, frame, cp.classCodePath());
	    else if (menu ==   methodMenu)    actionMethodMenu(label, frame, cp);
	    else if (menu == messagesMenu)  messagesMenu.spawn(label, frame, cp);
	    else done = false;
	    frame.setCursor(saveCursor);
	    return done;
	} else {
	    return false;
	}
    }

    protected final DejavaMenu createFileMenu() {
	DejavaMenu menu = new DejavaMenu(MENU_FILE);
	createFileEditMenu(menu);
	menu.add(MENU_RAISE_TRANSCRIPT);
	menu.add(MENU_SYNC_DATABASE);
	menu.add(MENU_QUIT);
	return menu;
    }

    protected final DejavaMenu createEditMenu() {
	DejavaMenu menu = new DejavaMenu(MENU_EDIT, true);
	menu.add(MENU_COPY);
	menu.add(MENU_CUT);
	menu.add(MENU_PASTE);
	menu.addSeparator();
	menu.add(MENU_SEARCH_REPLACE);
	menu.addSeparator();
	menu.add(MENU_SHIFT_LINE_RIGHT);
	menu.add(MENU_SHIFT_LINE_LEFT);
	menu.add(MENU_SHIFT_BLOCK_RIGHT);
	menu.add(MENU_SHIFT_BLOCK_LEFT);
	menu.add(MENU_SET_SHIFT_WIDTH);
	menu.addSeparator();
	//menu.add(MENU_SELECT_BLOCK);
	menu.add(MENU_BEGINNING_OF_BLOCK);
	menu.add(MENU_END_OF_BLOCK);
	return menu;
    }

    protected DejavaMenu createOptionMenu() {
	return null;
    }

    protected final DejavaMenu createProjectMenu() {
	DejavaMenu menu = new DejavaMenu(MENU_PROJECT);
	menu.add(MENU_SYNC);
	menu.add(MENU_GREP);
	menu.addSeparator();
	menu.add(MENU_REBUILD_DATABASE);
	menu.addSeparator();
	menu.add(MENU_SPAWN);
	return menu;
    }

    protected final DejavaMenu createPackageMenu() {
	DejavaMenu menu = new DejavaMenu(MENU_PACKAGE);
	menu.add(MENU_SYNC);
	menu.add(MENU_COMPILE);
	menu.add(MENU_COMPILE_UPDATED);
	menu.add(MENU_GREP);
	menu.addSeparator();
	createPackageEditMenu(menu);
	menu.add(MENU_REBUILD_DATABASE);
	menu.addSeparator();
	menu.add(MENU_SPAWN);
	return menu;
    }

    protected final DejavaMenu createClassMenu() {
	DejavaMenu menu = new DejavaMenu(MENU_CLASS);
	menu.add(MENU_SYNC);
	menu.add(MENU_COMPILE);
	menu.add(MENU_EXECUTE);
	menu.add(MENU_EXECUTE_WITH_ARGS);
	menu.add(MENU_EXECUTE_WITH_HTML);
	menu.add(MENU_GREP);
	menu.addSeparator();
	createClassEditMenu(menu);
	menu.add(MENU_SPAWN);
	menu.add(MENU_HIERARCHY);
	menu.add(MENU_IMPLEMENTERS);
	menu.add(MENU_USERS);
	return menu;
    }

    protected final DejavaMenu createMethodMenu() {
	DejavaMenu menu = new DejavaMenu(MENU_METHOD);
	messagesMenu = new DejavaMessagesMenu(MENU_MESSAGES);
	messagesMenu.disable();

	createMethodEditMenu(menu);
	menu.add(MENU_SPAWN);
	menu.add(MENU_HIERARCHY);
	menu.add(MENU_IMPLEMENTERS);
	menu.add(MENU_SENDERS);
	menu.add(messagesMenu);
	return menu;
    }

    protected void createFileEditMenu(DejavaMenu menu) {
    }

    protected void createPackageEditMenu(DejavaMenu menu) {
    }

    protected void createClassEditMenu(DejavaMenu menu) {
    }

    protected void createMethodEditMenu(DejavaMenu menu) {
    }

    protected void updateFileMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
   }

    protected void updateEditMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	if (cp.sourceFileManager() != null && editArea.isEditable()) {
	    menu.enable(MENU_CUT);
	    menu.enable(MENU_PASTE);
	    menu.enable(MENU_SHIFT_BLOCK_RIGHT);
	    menu.enable(MENU_SHIFT_BLOCK_LEFT);
	    menu.enable(MENU_SHIFT_LINE_RIGHT);
	    menu.enable(MENU_SHIFT_LINE_LEFT);
	} else {
	    menu.disable(MENU_CUT);
	    menu.disable(MENU_PASTE);
	    menu.disable(MENU_SHIFT_BLOCK_RIGHT);
	    menu.disable(MENU_SHIFT_BLOCK_LEFT);
	    menu.disable(MENU_SHIFT_LINE_RIGHT);
	    menu.disable(MENU_SHIFT_LINE_LEFT);
	}
	menu.enable(MENU_SET_SHIFT_WIDTH);
	if (cp.classManager() != null) {
	    //menu.enable(MENU_SELECT_BLOCK);
	    menu.enable(MENU_BEGINNING_OF_BLOCK);
	    menu.enable(MENU_END_OF_BLOCK);
	} else {
	    //menu.disable(MENU_SELECT_BLOCK);
	    menu.disable(MENU_BEGINNING_OF_BLOCK);
	    menu.disable(MENU_END_OF_BLOCK);
	}
	if (replacer != null && replacer.isVisible()) replacer.updateActibity();
    }

    protected void updateOptionMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
    }

    protected void updateProjectMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	if (cp.projectManager() == null) {
	    menu.disable(MENU_SYNC);
	    menu.disable(MENU_GREP);
	    menu.disable(MENU_REBUILD_DATABASE);
	    menu.disable(MENU_SPAWN);
	} else {
	    menu.enable(MENU_SYNC);
	    if (Grep.canExecute) {
		menu.enable(MENU_GREP);
	    } else {
		menu.disable(MENU_GREP);
	    }
	    menu.enable(MENU_REBUILD_DATABASE);
	    menu.enable(MENU_SPAWN);
	}
    }

    protected void updatePackageMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	if (cp.packageManager() == null) {
            menu.disable(MENU_SYNC);
	    menu.disable(MENU_COMPILE);
	    menu.disable(MENU_COMPILE_UPDATED);
            menu.disable(MENU_GREP);
            menu.disable(MENU_REBUILD_DATABASE);
            menu.disable(MENU_SPAWN);
        } else {
            menu.enable(MENU_SYNC);
	    if (Compile.canExecute) {
		menu.enable(MENU_COMPILE);
		menu.enable(MENU_COMPILE_UPDATED);
	    } else {
		menu.disable(MENU_COMPILE);
		menu.disable(MENU_COMPILE_UPDATED);
	    }
	    if (Grep.canExecute) {
		menu.enable(MENU_GREP);
	    } else {
		menu.disable(MENU_GREP);
	    }
            menu.enable(MENU_REBUILD_DATABASE);
            menu.enable(MENU_SPAWN);
	}
    }

    protected void updateClassMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	menu.disable(MENU_COMPILE);
	menu.disable(MENU_EXECUTE);
	menu.disable(MENU_EXECUTE_WITH_ARGS);
	menu.disable(MENU_EXECUTE_WITH_HTML);
	menu.disable(MENU_GREP);
	menu.disable(MENU_IMPLEMENTERS);
	menu.enable(MENU_USERS);
	ClassManager cm = cp.classManager();
        if (cm == null) {
            menu.disable(MENU_SYNC);
	    menu.disable(MENU_COMPILE);
            menu.disable(MENU_GREP);
            menu.disable(MENU_SPAWN);
            menu.disable(MENU_HIERARCHY);
            menu.disable(MENU_IMPLEMENTERS);
            menu.disable(MENU_USERS);
        } else {
            menu.enable(MENU_SYNC);
	    if (Compile.canExecute) {
		menu.enable(MENU_COMPILE);
	    }
	    if (ClassManager.canExecute) {
		if (cm.hasMainMethod()) {
		    menu.enable(MENU_EXECUTE);
		    menu.enable(MENU_EXECUTE_WITH_ARGS);
		}
		if (cm.isApplet()) {
		    menu.enable(MENU_EXECUTE);
		    menu.enable(MENU_EXECUTE_WITH_ARGS);
		    menu.enable(MENU_EXECUTE_WITH_HTML);
		}
	    }
            menu.enable(MENU_SPAWN);
            menu.enable(MENU_HIERARCHY);
	    if (Grep.canExecute) {
		menu.enable(MENU_GREP);
		menu.enable(MENU_USERS);
		if (cm.isInterface()) {
		    menu.enable(MENU_IMPLEMENTERS);
		}
	    }
        }
    }

    protected void updateMethodMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	menu.disable(MENU_IMPLEMENTERS);
	menu.disable(MENU_SENDERS);
	menu.disable(MENU_MESSAGES);
	menu.disable(MENU_SPAWN);
	menu.disable(MENU_HIERARCHY);
	MethodManager mm = cp.methodManager();
        if (mm != null && !(mm instanceof HeaderManager)) {
	    menu.enable(MENU_SPAWN);
	    menu.enable(MENU_HIERARCHY);
	    if (ClassManager.canExecute) {
		menu.enable(MENU_IMPLEMENTERS);
		menu.enable(MENU_SENDERS);
		messagesMenu.clear();
		try {
		    Enumeration messages = mm.messages();
		    while (messages.hasMoreElements()) {
			IdentifierSpec spec = (IdentifierSpec)messages.nextElement();
			if (spec.isMethod() >= IdentifierSpec.MAYBE) {
			    messagesMenu.add(spec);
			}
		    }
		} catch (DescriptionException e) {
		}
		if (messagesMenu.countItems() != 0) {
		    menu.enable(MENU_MESSAGES);
		}
	    }
	}
    }

    protected void actionFileMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_RAISE_TRANSCRIPT)) {
	    Transcript.raise();
	} else if (label.equals(MENU_SYNC_DATABASE)) {
	    SystemManager.sync();
	} else if (label.equals(MENU_QUIT)) {
	    frame.close();
	    frame.dispose();
	}
    }

    protected void actionEditMenu(String label, DejavaFrame frame, CodePath cp) {
	if (editArea == null) {
	    return;
	}
	if (label.equals(MENU_COPY)) {
	    buffer = frame.getSelectedCode();
	} else if (label.equals(MENU_CUT)) {
	    buffer = frame.getSelectedCode();
	    frame.replaceSelectedCode("");
	} else if (label.equals(MENU_PASTE)) {
	    frame.replaceSelectedCode(buffer);
	} else if (label.equals(MENU_SEARCH_REPLACE)) {
	    if (replacer == null) {
		replacer = new Replacer(frame, editArea);
	    }
	    replacer.show();
	} else if (label.equals(MENU_SHIFT_BLOCK_RIGHT)) {
	    Editor.shiftBlockRight(editArea);
	} else if (label.equals(MENU_SHIFT_BLOCK_LEFT)) {
	    Editor.shiftBlockLeft(editArea);
	} else if (label.equals(MENU_SHIFT_LINE_RIGHT)) {
	    Editor.shiftLineRight(editArea);
	} else if (label.equals(MENU_SHIFT_LINE_LEFT)) {
	    Editor.shiftLineLeft(editArea);
	} else if (label.equals(MENU_SET_SHIFT_WIDTH)) {
	    Editor.setShiftWidth(frame);
	} else if (label.equals(MENU_SELECT_BLOCK)) {
	    Editor.selectBlock(editArea);
	} else if (label.equals(MENU_BEGINNING_OF_BLOCK)) {
	    Editor.beginningOfBlock(editArea);
	} else if (label.equals(MENU_END_OF_BLOCK)) {
	    Editor.endOfBlock(editArea);
	}
    }

    protected void actionOptionMenu(String label, DejavaFrame frame, CodePath cp) {
    }

    protected void actionProjectMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_SYNC)) {
	    frame.sync(cp);
	} else if (label.equals(MENU_GREP)) {
	    frame.grep(cp);
	} else if (label.equals(MENU_REBUILD_DATABASE)) {
	    frame.rebuild(cp);
	} else if (label.startsWith(MENU_SPAWN)) {
	    frame.spawn(cp);
	}
    }

    protected void actionPackageMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_SYNC)) {
	    frame.sync(cp);
	} else if (label.equals(MENU_COMPILE)) {
	    frame.compile(cp, false);
	} else if (label.equals(MENU_COMPILE_UPDATED)) {
	    frame.compile(cp, true);
	} else if (label.equals(MENU_GREP)) {
	    frame.grep(cp);
	} else if (label.equals(MENU_REBUILD_DATABASE)) {
	    frame.rebuild(cp);
	} else if (label.equals(MENU_SPAWN)) {
	    frame.spawn(cp);
	}
    }

    protected void actionClassMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_SYNC)) {
	    frame.sync(cp);
	} else if (label.equals(MENU_COMPILE)) {
	    frame.compile(cp, false);
	} else if (label.equals(MENU_EXECUTE)) {
	    cp.classManager().execute(null);
	} else if (label.equals(MENU_EXECUTE_WITH_ARGS)) {
	    String arg = DejavaDialog.request(frame, "arguments:");
	    if (arg != null) {
		cp.classManager().execute(arg);
	    }
	} else if (label.equals(MENU_EXECUTE_WITH_HTML)) {
	    File f = new File(cp.sourceFileManager().absolutePath());
	    DejavaFileDialog fd = new DejavaFileDialog(frame, "HTML file for execute");
	    fd.setDirectory(f.getParent());
	    fd.setPostFix("*.html");
	    String html = fd.request();
	    if (html != null) {
		f = new File(html);
		if (f.isFile()) {
		    cp.classManager().executeWithHTML(html);
		} else {
		    DejavaDialog.information(frame, html + " is not a HTML file.");
		}
	    }
	} else if (label.equals(MENU_GREP)) {
	    frame.grep(cp);
	} else if (label.equals(MENU_SPAWN)) {
	    frame.spawn(cp);
	} else if (label.equals(MENU_HIERARCHY)) {
	    frame.spawnHierarchy(cp);
	} else if (label.equals(MENU_IMPLEMENTERS)) {
	    frame.spawnImplementers(cp);
	} else if (label.equals(MENU_USERS)) {
	    frame.spawnUsers(cp);
	}
    }

    protected void actionMethodMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_SPAWN)) {
	    frame.spawn(cp);
	} else if (label.equals(MENU_HIERARCHY)) {
	    frame.spawnHierarchy(cp);
	} else if (label.equals(MENU_IMPLEMENTERS)) {
	    frame.spawnImplementers(cp);
	} else if (label.equals(MENU_SENDERS)) {
	    frame.spawnSenders(cp);
	} else if (label.equals(MENU_MESSAGES)) {
	    // does not work
	    // messagesMenu.spawn(cp, frame);
	}
    }
}
