/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.gui;

import dejava.sys.*;
import dejava.util.*;
import dejava.lang.*;
import java.util.*;
import java.awt.*;

class DejavaMessagesMenu extends DejavaMenu {
    Hashtable idspecs = new Hashtable();

    DejavaMessagesMenu(String label) {
	super(label);
    }

    public void add(IdentifierSpec idspec) {
	Enumeration names = idspec.names();
	while (names.hasMoreElements()) {
	    String label = (String)names.nextElement();
	    idspecs.put(label, idspec);
	    add(label);
	}
    }

    synchronized void clear() {
	for (int i = countItems(); --i >= 0; ) {
	    remove(i);
	}
	idspecs = new Hashtable();
    }

    void spawn(String label, DejavaFrame frame, CodePath cp) {
	IdentifierSpec idspec = (IdentifierSpec)idspecs.get(label);
	frame.spawnImplementers(cp, idspec, label);
    }

    void spawn(CodePath cp, DejavaFrame frame) {
	String select = frame.getSelectedCode();
	if (select.length() > 0) {
	    IdentifierSpec idspec = (IdentifierSpec)idspecs.get(select);
	    frame.spawnImplementers(cp, idspec, select);
	}
    }
}
