/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.Frame;
import java.awt.Event;
import dejava.sys.SystemManager;

class DelegateEventFrame extends Frame implements EventHandler {
    private EventDelegater eventDelegater;

    DelegateEventFrame() {
	super();
    }

    DelegateEventFrame(String title) {
	super(title);
    }

    public synchronized final boolean postEvent(Event ev) {
	if (eventDelegater != null) {
	    eventDelegater.delegate(ev);
	    if (!SystemManager.onWin32 && SystemManager.onJDK1_0) {
		return false;
	    } else {
		return true;
	    }
	} else {
	    return super.postEvent(ev);
	}
    }

    public final void postEvent0(Event ev) {
	switch (ev.id) {
	case Event.LIST_SELECT:
	case Event.LIST_DESELECT:
	case Event.ACTION_EVENT:
	    int saveCursor = getCursorType();
	    setCursor(Frame.WAIT_CURSOR);
	    getToolkit().sync();
	    super.postEvent(ev);
	    setCursor(saveCursor);
	    break;
	default:
	    super.postEvent(ev);
	}
    }

    public void show() {
	delegater(true);
	super.show();
    }

    public void hide() {
	super.hide();
	delegater(false);
    }

    private final synchronized void delegater(boolean start) {
	if (start) {
	    if (eventDelegater == null) {
		eventDelegater = new EventDelegater(this);
	    }
	} else {
	    if (eventDelegater != null) {
		eventDelegater.dispose();
		eventDelegater = null;
	    }
	}
    }
}
