/*
 * Copyright (c) 1996 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.Event;
import java.util.Vector;

class EventDelegater implements Runnable {

    private EventHandler handler;

    Thread eventHandleThread;

    private Vector events = new Vector();

    EventDelegater(EventHandler handler) {
	this.handler = handler;
	events = new Vector();
	eventHandleThread = new Thread(this);
	eventHandleThread.start();
    }

    synchronized void dispose() {
	if (eventHandleThread != null) {
	    eventHandleThread.stop();
	    eventHandleThread = null;
	    events = null;
	    handler = null;
	}
    }

    synchronized void delegate(Event event) {
	events.addElement(event);
	notifyAll();
    }

    public void run() {
	Event event;
	while ((event = getEvent()) != null) {
	    try {
		handler.postEvent0(event);
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
    }

    private synchronized final Event getEvent() {
	while (eventHandleThread != null && events.size() == 0) {
	    try {
		wait();
	    } catch (Exception e) {
	    }
	}
	if (eventHandleThread == null) {
	    return null;
	} else {
	    Event event = (Event)events.firstElement();
	    events.removeElementAt(0);
	    return event;
	}
    }
}
