/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.*;
import dejava.sys.SystemManager;
import dejava.sys.DejavaProperties;

class FocusDialog extends DelegateEventFrame {
    Container parentFrame;

    FocusDialog(Frame frame, boolean modal) {
//	super(frame, false);
	super();
	setTitle("dialog");
	setFont(DejavaProperties.getFont("font.dialog"));
	parentFrame = frame;
    }

    public void show() {
	pack();
	super.show();
	Rectangle parent = getParent().bounds();
	Dimension me = size();
	move(parent.x + (parent.width  - me.width ) / 2,
	     parent.y + (parent.height - me.height) / 2);
    }

    public boolean mouseMove(Event ev, int x, int y) {
	if (SystemManager.onSolaris) {
	    Component comp = locate(this, x, y);
	    Container cont = null;
	    while ((comp instanceof Container) && comp != cont) {
		cont = (Container)comp;
		Point loc = cont.location();
		x -= loc.x;
		y -= loc.y;
		comp = locate(cont, x, y);
	    }
	    if (comp != null) {
		comp.requestFocus();
		return true;
	    }
	}
	return super.mouseMove(ev, x, y);
    }

    /**  
     * Checks whether a specified x,y location is "inside" this
     * Component. By default, x and y are inside an Component if
     * they fall within the bounding box of that Component.
     * @param x the x coordinate
     * @param y the y coordinate
     * @see #locate
     */
    private final static synchronized boolean inside(Component comp, int x, int y) {
	Rectangle target = comp.bounds();
	x -= target.x;
	y -= target.y;
	return (x >= 0) && (x < target.width) && (y >= 0) && (y < target.height);
    }

    /**
     * Locates the component that contains the x,y position.
     * @param x the x coordinate
     * @param y the y coordinate
     * @return null if the component is not within the x and y
     * coordinates; returns the component otherwise. 
     * @see #inside 
     */
    private final static Component locate(Container cont, int x, int y) {
	if (!cont.inside(x, y)) {
	    return null;
	}
	int ncomponents = cont.countComponents();
	for (int i = 0 ; i < ncomponents ; i++) {
	    Component comp = cont.getComponent(i);
	    if ((comp != null) && inside(comp, x, y)) {
		return comp;
	    }
	}
	return cont;
    }

    public Container getParent() {
	if (parentFrame != null) {
	    return parentFrame;
	} else {
	    return super.getParent();
	}
    }
}
