/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import java.util.*;
import java.awt.*;

class HierarchyBrowser extends Browser implements Runnable {

    int selection = -1;
    Vector codePath = new Vector();

    Thread hierarchyThread = null;

    static void openOn(CodePath cp, CodePath select, String title) {
	HierarchyBrowser hb = new HierarchyBrowser(cp, select, title);
	hb.open();
	hb.start();
    }

    protected void start() {
	hierarchyThread = new Thread(this);
	hierarchyThread.start();
    }

    public void run() {
	if (Thread.currentThread() == hierarchyThread) {
	    try {
		Thread.sleep(100);
	    } catch (InterruptedException e) {
	    }
	    ClassManager cm = current.classManager();
	    List list;
	    String methodName;
	    if (clsList != null) {
		list = clsList;
		methodName = null;
	    } else {
		list = mtdList;
		methodName = current.methodManager().name();
	    }
	    Enumeration en = cm.hierarchy(methodName);
	    while (en.hasMoreElements()) {
		CodePath cp = (CodePath)en.nextElement();
		codePath.addElement(cp);
		list.addItem(cp.printString());
		try {
		    Thread.sleep(100);
		} catch (InterruptedException e) {
		}
	    }
	}
    }

    /**
     * the constructor
     */
    public HierarchyBrowser(CodePath cp, CodePath select, String title) {
	super(cp, select, title);
	codePath.addElement(new CodePath(cp));
	codePath.addElement(new CodePath(select));
	String path = select.printString();
	if (clsList != null) {
	    clsList.addItem(path);
	} else {
	    mtdList.addItem(path);
	}
	selection = 0;
    }

    public boolean handleEvent(Event ev) {
	try {
	    if (ev.target == clsList || ev.target == mtdList) {
		if (!acceptWithConfirm()) {
		    update();
		} else if (ev.target == mtdList && clsList != null) {
		    current.methodManager(mtdList.getSelectedItem());
		    updateCurrent();
		} else {
		    selection = ((List)ev.target).getSelectedIndex();
		    CodePath cp = (CodePath)codePath.elementAt(selection + 1);
		    if (ev.target == clsList) {
			current = cp;
			current.methodManager(mtdList.getSelectedItem());
			updateMethods();
		    } else {
			current = (selection < 0) ? startup : cp;
			updateCurrent();
		    }
		}
		return true;
	    }
	} catch (DejavaException e) {
	    current.classManager((ClassManager)null);
	    DejavaFrame.updateNotify(current);
	    update();
	    return true;
	}
	return super.handleEvent(ev);
    }

    protected void updateClasses() throws DejavaException  {
	if (clsList != null) {
	    clsList.selectAndVisible(selection);
	    clsList.reshape();
	    super.updateMethods();
	} else {
	    updateMethods();
	}
    }

    protected void updateMethods() throws DejavaException {
	if (clsList != null) {
	    super.updateMethods();
	} else {
	    mtdList.selectAndVisible(selection);
	    mtdList.reshape();
	    updateCurrent();
	}
    }
}
