/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import dejava.lang.*;
import dejava.util.*;

class ImplementersFrame extends GrepFrame {
    IdentifierSpec idspec;
    MethodSpec mspec;

    static void openOn(CodePath cp, IdentifierSpec idspec, String label)
    throws DejavaException {
	String name = idspec.name();
	if (name.equals("this")) {
	    name = cp.className();
	} else if (name.equals("super")) {
	    try {
		ClassManager superClass = cp.classManager().superClass();
		name = superClass.name();
		cp = superClass.getCodePath();
	    } catch (DejavaException e) {
		SystemManager.information("Could not find super class of: " + cp.className());
		return;
	    }
	}
	ImplementersFrame frame = new ImplementersFrame(cp, idspec, name, label);
	frame.open();
	frame.start();
    }

    static void openOn(MethodManager mman) throws DejavaException {
	ImplementersFrame frame = new ImplementersFrame(mman.getCodePath(), mman.spec());
	frame.open();
	frame.start();
    }

    ImplementersFrame(CodePath cp, MethodSpec mspec) throws DejavaException {
	this(cp, mspec.methodName(), mspec.prototype());
	this.mspec = mspec;
    }

    ImplementersFrame(CodePath cp, IdentifierSpec idspec, String name,
		      String label) throws DejavaException {
	this(cp, name, label);
	this.idspec = idspec;
    }

    ImplementersFrame(CodePath cp, String name, String label)
    throws DejavaException {
	super(cp, "([ \t]" + name + "|^" + name + ")[ \t]*", "Implementers of: " + label);
    }

    protected void initialize(CodePath cp, String pattern, String title)
    throws DejavaException {
	//super.initialize(cp.projectCodePath(), pattern, title);
	super.initialize(CodePath.nullCodePath, pattern, title);
	super.showPattern(false);
    }

    protected boolean addItem(ListItem item) {
	CodePath cp = item.codePath();
	MethodManager methodManager = cp.methodManager();
	if (methodManager != null) {
	    MethodSpec ms = methodManager.spec();
	    if (mspec != null) {
		if (!ms.prototype().equals(mspec.prototype())) return false;
	    } else if (ms.methodName().equals(idspec.name())) {		// should check argument count
		int argCount = 0;
		String arguments = ms.arguments();
		int length = arguments.length();
		if (length > 0) {
		    argCount = 1;			// at least one argument
		    for (int i = 0; i < length; i++) {
			if (arguments.charAt(i) == ',') argCount++;
		    }
		}
		if (((1L << argCount) & idspec.argumentCountBits()) == 0) return false;
	    } else return false;
	    // maybe same method
	    return super.addItem(item);
	}
	return false;
    }
}
