/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import dejava.util.*;

import java.awt.*;
import java.util.Date;
import java.util.Vector;
import java.util.Enumeration;
import java.io.InputStream;
import java.io.DataInputStream;
import java.io.StringBufferInputStream;
import java.io.IOException;

abstract class ListingCommand extends ListingFrame implements Runnable {
    private String name;
    private Command command;
    protected Thread commandThread = null;
    protected Process commandProcess = null;

    ListingCommand(CodePath cp, String title, String name) {
	super(cp, title);
	this.name = name;
    }

    protected DejavaMenuBar createMenuBar() {
	return new CommandMenuBar();
    }

    abstract protected void doCommand(DataInputStream messages) throws IOException;

    public void run() {
	if (Thread.currentThread() == commandThread) {
	    try {
		command.exec();
		InputStream stream = command.getInputStream();
		doCommand(new DataInputStream(stream));
		stream.close();
	    } catch (IOException e) {
		abort(e);
	    }
	    end();
	}
    }

    public synchronized void start(Command cmd) {
	if (cmd == null) return;
	select(-1);
	addMessageWithDate(name + " started");
	command = cmd;
	commandThread = new Thread(this);
	commandThread.setPriority(Thread.MIN_PRIORITY);
	commandThread.start();
	((CommandMenuBar)getMenuBar()).fileMenu.enable("stop");
    }

    protected void restart(Command cmd) {
	stop();
	if (syncAndClearListItems()) {
	    start(cmd);
	}
    }

    private void abort(Exception e) {
	end(" aborted: " + e.getMessage());
    }

    private void end() {
	end(" ended  ");
    }

    private synchronized void end(String message) {
	((CommandMenuBar)getMenuBar()).fileMenu.disable("stop");
	boolean stopped = false;
	if (command != null) {
	    command.stop();
	    command = null;
	    stopped = true;
	}
	if (commandThread != null) {
	    commandThread = null;
	    stopped = true;
	}
	if (stopped) addMessageWithDate(name + message);
	update();
    }

    synchronized void stop() {
	end(" stopped");
    }

    protected void addMessageWithDate(String message) {
	addMessage("--- " + message + ": " + (new Date()).toString() + "\n");
    }

    void close() {
	stop();
	super.close();
    }
}
