/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import dejava.lang.ClassSpec;

import dejava.gui.DejavaMenuBar;

class ListingMenuBar extends DejavaMenuBar {
    DejavaMenu fileMenu;

    protected static final String MENU_MARK_ALL            = "mark all";
    protected static final String MENU_MARK_SAME_PACKAGE   = "mark same package";
    protected static final String MENU_MARK_SAME_CLASS     = "mark same class";
    protected static final String MENU_MARK_SAME_SELECTOR  = "mark same selector";
    protected static final String MENU_MARK_SAME           = "mark same";
    protected static final String MENU_MARK_SELECTION      = "mark selection";
    protected static final String MENU_OPEN_REPLACER       = "open replacer";
    protected static final String MENU_SPAWN_CLASS_BROWSER = "spawn class browser";
    protected static final String MENU_SPAWN_MARKED        = "spawn marked";
    protected static final String MENU_SPAWN_SAME_PACKAGE  = "spawn same package";
    protected static final String MENU_SPAWN_SAME_CLASS    = "spawn same class";
    protected static final String MENU_SPAWN_SAME_SELECTOR = "spawn same selector";
    protected static final String MENU_SPAWN_SAME          = "spawn same";
    protected static final String MENU_SPAWN_UNMARKED      = "spawn unmarked";
    protected static final String MENU_UNMARK_ALL          = "unmark all";
    protected static final String MENU_UNMARK_SELECTION    = "unmark selection";

    protected void createFileEditMenu(DejavaMenu menu) {
	fileMenu = menu;
	if (createFileCommandMenu(menu)) {
	    menu.addSeparator();
	}
	menu.add(MENU_MARK_SELECTION);
	menu.add(MENU_UNMARK_SELECTION);
	menu.add(MENU_MARK_ALL);
	menu.add(MENU_UNMARK_ALL);
	menu.add(MENU_SPAWN_MARKED);
	menu.add(MENU_SPAWN_UNMARKED);
	menu.addSeparator();
	if (createFileEditMoreMenu(menu)) {
	    menu.add(MENU_OPEN_REPLACER);
	}
	menu.addSeparator();
    }

    protected boolean createFileCommandMenu(DejavaMenu menu) {
	return false;
    }

    protected boolean createFileEditMoreMenu(DejavaMenu menu) {
	return true;
    }

    protected void createPackageEditMenu(DejavaMenu menu) {
	menu.add(MENU_MARK_SAME_PACKAGE);
	menu.add(MENU_SPAWN_SAME_PACKAGE);
	menu.addSeparator();
    }

    protected void createClassEditMenu(DejavaMenu menu) {
	menu.add(MENU_MARK_SAME_CLASS);
	menu.add(MENU_SPAWN_SAME_CLASS);
	menu.addSeparator();
    }

    protected void createMethodEditMenu(DejavaMenu menu) {
	menu.add(MENU_MARK_SAME);
	menu.add(MENU_MARK_SAME_SELECTOR);
	menu.add(MENU_SPAWN_SAME);
	menu.add(MENU_SPAWN_SAME_SELECTOR);
	menu.addSeparator();
    }

    protected void actionFileMenu(String label, DejavaFrame frame, CodePath cp) {
	ListingFrame lf = (ListingFrame)frame;
	if (label.equals(MENU_MARK_SELECTION)) {
	    lf.mark(lf.selection);
	} else if (label.equals(MENU_UNMARK_SELECTION)) {
	    lf.unmark(lf.selection);
	} else if (label.equals(MENU_MARK_ALL)) {
	    lf.markAll();
	} else if (label.equals(MENU_UNMARK_ALL)) {
	    lf.unmarkAll();
	} else if (label.equals(MENU_SPAWN_MARKED)) {
	    lf.spawnMarkedItems(true);
	} else if (label.equals(MENU_SPAWN_UNMARKED)) {
	    lf.spawnMarkedItems(false);
	} else if (label.equals(MENU_OPEN_REPLACER)) {
            lf.replace(editArea);
	} else {
	    super.actionFileMenu(label, frame, cp);
	}
    }

    protected void actionPackageMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_MARK_SAME_PACKAGE)) {
	    ((ListingFrame)frame).markMatchingItems(cp, false, true);
	} else if (label.equals(MENU_SPAWN_SAME_PACKAGE)) {
	    ((ListingFrame)frame).spawnMatchingItems(cp, false);
	} else {
	    super.actionPackageMenu(label, frame, cp);
	}
    }

    protected void actionClassMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_MARK_SAME_CLASS)) {
	    ((ListingFrame)frame).markMatchingItems(cp, false, true);
	} else if (label.equals(MENU_SPAWN_SAME_CLASS)) {
	    ((ListingFrame)frame).spawnMatchingItems(cp, false);
	} else {
	    super.actionClassMenu(label, frame, cp);
	}
    }

    protected void actionMethodMenu(String label, DejavaFrame frame, CodePath cp) {
	if (label.equals(MENU_MARK_SAME)) {
	    ((ListingFrame)frame).markMatchingItems(cp, true, true);
	} else if (label.equals(MENU_MARK_SAME_SELECTOR)) {
	    CodePath argCp = new CodePath(cp);
	    argCp.classManager((ClassManager)null);
	    argCp.methodManager(cp.methodManager());
	    ((ListingFrame)frame).markMatchingItems(argCp, false, true);
	} else if (label.equals(MENU_SPAWN_SAME)) {
	    ((ListingFrame)frame).spawnMatchingItems(cp, true);
	} else if (label.equals(MENU_SPAWN_SAME_SELECTOR)) {
	    CodePath argCp = new CodePath(cp);
	    argCp.classManager((ClassManager)null);
	    argCp.methodManager(cp.methodManager());
	    ((ListingFrame)frame).spawnMatchingItems(argCp, false);
	} else {
	    super.actionMethodMenu(label, frame, cp);
	}
    }

    protected void updateFileMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
	ListingFrame lf = (ListingFrame)frame;
	if (lf.selection != -1) {
	    menu.enable(MENU_MARK_SELECTION);
	    menu.enable(MENU_UNMARK_SELECTION);
	} else {
	    menu.disable(MENU_MARK_SELECTION);
	    menu.disable(MENU_UNMARK_SELECTION);
	}
	super.updateFileMenuActivity(menu, frame, cp);
    }

    protected void updatePackageMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
        if (cp.packageManager() == null) {
            menu.disable(MENU_SPAWN_SAME_PACKAGE);
            menu.disable(MENU_MARK_SAME_PACKAGE);
        } else {
            menu.enable(MENU_SPAWN_SAME_PACKAGE);
            menu.enable(MENU_MARK_SAME_PACKAGE);
        }
	super.updatePackageMenuActivity(menu, frame, cp);
    }

    protected void updateClassMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
        if (cp.classManager() == null) {
            menu.disable(MENU_SPAWN_SAME_CLASS);
            menu.disable(MENU_MARK_SAME_CLASS);
        } else {
            menu.enable(MENU_SPAWN_SAME_CLASS);
            menu.enable(MENU_MARK_SAME_CLASS);
        }
	super.updateClassMenuActivity(menu, frame, cp);
    }

    protected void updateMethodMenuActivity(DejavaMenu menu, DejavaFrame frame, CodePath cp) {
        if (cp.methodManager() == null) {
	    if (cp.classManager() == null) {
                menu.disable(MENU_SPAWN_SAME);
                menu.disable(MENU_MARK_SAME);
	    } else {
                menu.enable(MENU_SPAWN_SAME);
                menu.enable(MENU_MARK_SAME);
	    }
            menu.disable(MENU_SPAWN_SAME_SELECTOR);
            menu.disable(MENU_MARK_SAME_SELECTOR);
        } else {
            if (cp.methodManager() instanceof HeaderManager) {
                menu.disable(MENU_SPAWN_SAME);
                menu.disable(MENU_SPAWN_SAME_SELECTOR);
                menu.disable(MENU_MARK_SAME);
                menu.disable(MENU_MARK_SAME_SELECTOR);
	    } else {
                menu.enable(MENU_SPAWN_SAME);
                menu.enable(MENU_SPAWN_SAME_SELECTOR);
                menu.enable(MENU_MARK_SAME);
                menu.enable(MENU_MARK_SAME_SELECTOR);
	    }
	}
	super.updateMethodMenuActivity(menu, frame, cp);
    }
}
