/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import java.awt.*;

import dejava.gui.Replacer;

class ListingReplacer extends Replacer {
    private ListingFrame listingFrame;
    private int index;

    ListingReplacer(ListingFrame lf, TextArea ta) {
	super(lf, ta);
	listingFrame = lf;
    }

    protected boolean backword() {
	int selection = listingFrame.selection;
	if (selection < 0) {
	    selection = listingFrame.list.countItems() - 1;
	    if (!listingFrame.select(selection)) return false;
	    int last = target.getText().length();
	    target.select(last, last);
	}
	while (!super.backword()) {
	    if (--selection < 0) {
		SystemManager.beep();
		return false;
	    }
	    if (listingFrame.itemAt(selection).isSameCode(
					listingFrame.itemAt(selection + 1))) {
		listingFrame.list.selectAndVisible(selection);
	    } else {
		if (!listingFrame.select(selection)) return false;
		int last = target.getText().length();
		target.select(last, last);
	    }
	}
	return true;
    }

    protected boolean forward() {
	int selection = listingFrame.selection;
	if (selection < 0) {
	    selection = 0;
	    if (!listingFrame.select(selection)) return false;
	    target.select(0, 0);
	}
	while (!super.forward()) {
	    if (++selection >= listingFrame.list.countItems()) {
		SystemManager.beep();
		return false;
	    }
	    if (listingFrame.itemAt(selection).isSameCode(
					listingFrame.itemAt(selection - 1))) {
		listingFrame.list.selectAndVisible(selection);
	    } else {
		if (!listingFrame.select(selection)) return false;
		target.select(0, 0);
	    }
	}
	return true;
    }
}
