/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import dejava.util.CodeLocation;
import dejava.util.CodeLocationException;
import java.awt.*;
import java.util.*;
import java.io.File;

class LocationFrame extends ListingFrame {
    CodeField inputField;

    String    defaultPath;
    String    defaultFile;

    /**
     * constractor
     */
    public LocationFrame(CodePath cp) {
	this(cp, "Location frame on: " + cp.printString());
    }

    /**
     * constractor
     */
    public LocationFrame(CodePath cp, String title) {
	super(cp, title);
        PackageManager pm = cp.packageManager();
        if (pm != null) {
            defaultPath = pm.path() + File.separator;
            if (cp.sourceFileManager() != null) {
                defaultFile = cp.sourceFileManager().name();
            }
        }
    }

    protected void createDisplayItems() {
	super.createDisplayItems();
	Panel locationArea = new Panel();
	locationArea.setLayout(new BorderLayout());
	locationArea.add(WEST, new Label("file:line"));
	locationArea.add(CENTER, inputField = new CodeField());
	listingArea.add(NORTH, locationArea);
    }

    /**
     * selected on text field
     */
    public boolean action(Event ev, Object arg) {
	if (ev.target != inputField) {
	    return super.action(ev, arg);
	}
	String lines = inputField.getText().trim();
	if (lines.length() == 0) {
	    return true;
	}
	inputField.setText("");

	String fileName;
	int    lineNumber;
	int    nextSelection = list.countItems();

	StringTokenizer st = new StringTokenizer(lines, "\n");
	while (st.hasMoreTokens()) {
	    String line = st.nextToken();
	    int pos = 0, len = line.length();
	    int colon, paren;

	    if ((colon = line.indexOf(':')) < 0) {
		if (defaultFile == null)
		    continue;
		fileName = defaultFile;
	    } else {
		if ((paren = line.lastIndexOf('(', colon)) >= 0)
		    pos = paren + 1;
	        fileName = line.substring(pos, colon);
	    }
	    pos = colon + 1;

	    //if (!fileName.startsWith(File.separator) && defaultPath != null)
		//fileName = defaultPath + fileName;

	    char c;
	    lineNumber = 0;
	    while ((c = line.charAt(pos)) >= '0' && c <= '9') {
		lineNumber = lineNumber * 10 + (int)(c - '0');
		if (++pos >= len)
		    break;
	    }
	    if (lineNumber == 0) continue;

	    line = line.trim();
	    CodeLocation code;
	    CodePath cp;
	    try {
		code = new CodeLocation(startup, fileName, lineNumber, line, 0, -1);
		cp = code.codePath();
	    } catch (CodeLocationException e) {
		code = null;
		cp = null;
	    }
	    if (cp != null && cp.classManager() != null) {
		addItem(code);
		list.reshape();
	    } else {
		SystemManager.messageln("fail to search location " +
				        fileName + ":" + lineNumber +
					", sorry.");
	    }
	}

	list.reshape();
	if (list.countItems() > nextSelection) {
	    list.selectAndVisible(nextSelection);
	    select(nextSelection);
	}

	return true;
    }

    protected ListingFrame copyCreate(CodePath cp) {
	return new LocationFrame(cp, "Same elements for: " + cp.printString());
    }
}
