/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.*;

public class MemoryMonitor extends Frame implements Runnable {

    Button updateButton = new DejavaButton("update now");
    Choice updateChoice = new Choice();
    int updateTime = 5 * 1000;

    Label usedLabel = new Label("", Label.RIGHT);
    Label totalLabel = new Label("", Label.RIGHT);
    Label percentLabel = new Label("", Label.LEFT);
    Button garbageCorrect = new DejavaButton("garbage correct");
    Slider slider = new Slider(100, 32);
    StringBuffer stringBuffer = new StringBuffer();

    Button closeButton = new DejavaButton("close");

    Thread updateThread;

    public MemoryMonitor() {
	super("dejava memory monitor");
	setFont(new Font("Dialog", Font.PLAIN, 10));
	update();

        updateChoice.addItem("1");
        updateChoice.addItem("2");
        updateChoice.addItem("3");
        updateChoice.addItem("5");
        updateChoice.addItem("10");
        updateChoice.addItem("20");
        updateChoice.addItem("30");
        updateChoice.addItem("60");
        updateChoice.addItem("stop");
	updateChoice.select(Integer.toString(updateTime/1000));

	Panel north = new Panel();
	north.add(new Label("update each"));
	north.add(updateChoice);
	north.add(new Label("sec. "));
	north.add(updateButton);

	Panel labels = new Panel();
	labels.setLayout(new GridLayout(2, 1));
	labels.add(new Label( "used memory", Label.RIGHT));
	labels.add(new Label("total memory", Label.RIGHT));

	Panel memories = new Panel();
	memories.setLayout(new GridLayout(2, 1));
	memories.add(usedLabel);
	memories.add(totalLabel);

	Panel bytes = new Panel();
	bytes.setLayout(new GridLayout(2, 1));
	bytes.add(new Label("bytes"));
	bytes.add(new Label("bytes"));

	Panel percents = new Panel();
	percents.setLayout(new GridLayout(2, 1));
	percents.add(percentLabel);
	percents.add(garbageCorrect);

	Panel north2 = new Panel();
	north2.add(labels);
	north2.add(memories);
	north2.add(bytes);
	north2.add(percents);

	Panel center = new Panel();
	center.setLayout(new BorderLayout());
	center.add("North", north2);
	center.add("Center", slider);

	Panel south = new Panel();
	south.add(closeButton);

	add("North", north);
	add("Center", center);
	add("South", south);
	pack();
    }

    public void show() {
	super.show();
	start();
    }

    synchronized void start() {
	stop();
	updateThread = new Thread(this);
	updateThread.start();
    }

    synchronized void stop() {
	if (updateThread != null) {
	    updateThread.stop();
	    updateThread = null;
	}
    }

    public void run() {
	while (updateThread != null) {
	    update();
	    try {
		Thread.sleep(updateTime);
	    } catch (InterruptedException e) {
	    }
	}
    }

    public void update() {
	Runtime runtime = Runtime.getRuntime();
	long total = runtime.totalMemory();
	long used  = total - runtime.freeMemory();
	int percent = (int)(used * 1000 / total);

	usedLabel.setText(sizeToString(used));
	totalLabel.setText(sizeToString(total));
	percentLabel.setText("(" + (percent / 10) + "." + (percent % 10) + "%)");
	slider.setValue(percent);
	slider.update();
    }

    synchronized String sizeToString(long size) {
	stringBuffer.setLength(0);
	stringBuffer.append(size);
	int i = stringBuffer.length();
	while ((i -= 3) > 0) {
	    stringBuffer.insert(i, ',');
	}
	return stringBuffer.toString();
    }

    public boolean handleEvent(Event e) {
	if (e.id == Event.WINDOW_DESTROY) {
	    close();
	    return true;
	}
	return super.handleEvent(e);
    }

    public boolean action(Event ev, Object arg) {
	if (ev.target == updateButton) {
	    update();
	} else if (ev.target == updateChoice) {
	    stop();
	    String choice = (String)arg;
	    if (Character.isDigit(choice.charAt(0))) {
		updateTime = Integer.parseInt(choice) * 1000;
		start();
	    }
	} else if (ev.target == garbageCorrect) {
	    Runtime.getRuntime().gc();
	    update();
	} else if (ev.target == closeButton) {
	    close();
	} else {
	    return false;
	}
	return true;
    }

    void close() {
	stop();
	hide();
    }

    public static void main(String args[]) {
	new MemoryMonitor().show();
    }
}

class Slider extends Canvas {
    int val;	// 0 - 1000 (1000 is 100%)

    Slider(int width, int height) {
	super();
	setForeground(Color.green);
	resize(width, height);
    }

    public void setValue(int val) {
	if (val < 0)   val = 0;
	if (val > 1000) val = 1000;
	this.val = val;
    }

    public void paint(Graphics g) {
	super.paint(g);

	Dimension d = size();
	int w = d.width - 5 * 2 - 2;
	int h = d.height - 5 * 2 - 2;
	g.setColor(getParent().getBackground());
	g.draw3DRect(5, 5, w, h, false);
	g.draw3DRect(6, 6, w-2, h-2, false);
	w -= 4;
	h -= 4;
	w = w * val / 1000;
	g.setColor(getForeground());
	g.draw3DRect(7, 7, w, h, true);
	g.draw3DRect(8, 8, w-2, h-2, true);
	g.fillRect(9, 9, w-3, h-3);
	getToolkit().sync();
    }

    public void update() {
	repaint();
    }
}
