/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.util.Vector;
import java.util.Enumeration;
import java.awt.*;
import dejava.sys.*;
import dejava.util.*;

class MethodOrder extends DejavaDialog {
    CodePath codePath;
    Frame frame;
    Object header;
    Vector methods = new Vector();
    DejavaList mtdList;
    int lastSelect = -1;

    MethodOrder(Frame f, CodePath cp) {
	super(f, "choose method name, then choose where to move it:");
	frame = f;
	codePath = cp;

	setFont(DejavaProperties.getFont("font.dialog"));
	mtdList = new DejavaList(20, false);
	mtdList.setFont(DejavaProperties.getFont("font.list"));
	add(CENTER, mtdList.makePanel());
	pack();

	try {
	    Enumeration methods = cp.classManager().methods();
	    header = methods.nextElement();
	    while (methods.hasMoreElements()) {
		this.methods.addElement(methods.nextElement());
	    }
	} catch (DejavaException e) {
	}
	update();
    }

    void update() {
	mtdList.clear();
	Enumeration methods = this.methods.elements();
	while (methods.hasMoreElements()) {
	    mtdList.addItem(((MethodManager)methods.nextElement()).spec().prototype());
	}
	mtdList.reshape();
    }

    public boolean handleEvent(Event ev) {
	if (ev.target == mtdList) {
	    switch (ev.id) {
	    case Event.LIST_SELECT:
	    case Event.ACTION_EVENT:
		int newSelect = mtdList.getSelectedIndex();
		if (newSelect != lastSelect) {
		    if (lastSelect < 0) {
			lastSelect = newSelect;
		    } else {
			Object mtd = methods.elementAt(lastSelect);
			methods.removeElementAt(lastSelect);
			methods.insertElementAt(mtd, newSelect);
			update();
			lastSelect = -1;
		    }
		    break;
		}
		mtdList.deselect(newSelect);
		// no break;
	    case Event.LIST_DESELECT:
		lastSelect = -1;
		break;
	    }
	    return true;
	}
	return super.handleEvent(ev);
    }

    public void actionLeftButton() {
	methods.insertElementAt(header, 0);
	codePath.classManager().changeMethodsOrder(methods.elements());
	DejavaFrame.updateNotify(codePath);
	super.actionLeftButton();
    }
}
