/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import dejava.lang.AccessFlags;
import dejava.lang.ClassSpec;
import dejava.lang.JavaLexical;
import java.awt.*;

public class NewClassDialog extends DejavaDialog {
    CodePath	codePath;
    ClassSpec	classSpec;
    TextField	className;
    TextField	superClassName;
    TextField	interfaceNames;
    Checkbox	isPublic;
    Checkbox	isFinal;
    Checkbox	isAbstract;

    public NewClassDialog(Frame f, CodePath cp, ClassSpec cs) {
	super(f, "new " + cs.typeAsString());

	codePath = cp;
	classSpec = cs;

	int rows = (cs.isInterface() ? 2 : 3);

	Panel labels = new Panel();
	labels.setLayout(new GridLayout(rows, 1));
	labels.add(new Label(cs.typeAsString(), Label.RIGHT));
	labels.add(new Label(ClassSpec.STR_EXTENDS, Label.RIGHT));
	if (rows == 3) {	// is class
	    labels.add(new Label(ClassSpec.STR_IMPLEMENTS, Label.RIGHT));
	}

	Panel fields = new Panel();
	fields.setLayout(new GridLayout(rows, 1));
	fields.add(className = new TextField(cs.className(), 30));
	fields.add(superClassName = new TextField(cs.superClassName(), 30));
	if (rows == 3) {	// is class
	    fields.add(interfaceNames = new TextField(cs.interfaceNames(), 30));
	}

	Panel modifiers = new Panel();
	modifiers.setLayout(new FlowLayout(FlowLayout.LEFT));
	isPublic = new Checkbox(AccessFlags.STR_PUBLIC, null, cs.isPublic());
	if (rows == 3) {	// is class
	    isAbstract = new Checkbox(AccessFlags.STR_ABSTRACT, null, cs.isAbstract());
	    isFinal = new Checkbox(AccessFlags.STR_FINAL, null, cs.isFinal());
	    modifiers.add(isAbstract);
	    modifiers.add(isPublic);
	    modifiers.add(isFinal);
	} else {
	    modifiers.add(isPublic);
	}

	Panel spec = new Panel();
	spec.setLayout(new BorderLayout());
	spec.add(WEST, labels);
	spec.add(CENTER, fields);

	Panel panel = new Panel();
	panel.setLayout(new BorderLayout());
	panel.add(NORTH, modifiers);
	panel.add(CENTER, spec);

	add(CENTER, panel);
	pack();
    }

    public ClassSpec getClassSpec() {
	return classSpec;
    }

    public void actionLeftButton() {
	String cn = className.getText().trim();
	if (cn.length() == 0) return;
	int illegal = JavaLexical.isIdentifier(cn);
	if (illegal >= 0) {
	    DejavaDialog.information(this, "illegal character '" +
					   cn.charAt(illegal) +
					   "' for " +
					   classSpec.typeAsString() + " name");
	    return;
	}
	String scn = superClassName.getText().trim();
	if (scn.length() == 0) scn = null;
	String in;
	if (!classSpec.isInterface()) {
	    in = interfaceNames.getText().trim();
	    if (in.length() == 0) in = null;
	} else {
	    in = null;
	}
	classSpec = new ClassSpec(cn, scn, in, classSpec.isInterface());
	classSpec.setPublic(isPublic.getState());
	if (!classSpec.isInterface()) {
	    classSpec.setAbstract(isAbstract.getState());
	    classSpec.setFinal(isFinal.getState());
	}
	super.actionLeftButton();
    }
}
