/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.gui;

import dejava.sys.*;
import dejava.lang.*;
import java.awt.*;

public class NewMethodDialog extends DejavaDialog {
    Frame	frame;
    CodePath	codePath;
    ClassSpec	classSpec;
    MethodSpec	methodSpec;
    StringBuffer description	= new StringBuffer();
    Choice	primitiveType;
    TextField	objectType;
    TextField	methodName;
    TextField	arguments	= new TextField(20);
    Choice	arrayChoice;
    TextField	throwsField	= new TextField(20);
    Checkbox	isPublic	= new Checkbox(AccessFlags.STR_PUBLIC);
    Checkbox	isProtected	= new Checkbox(AccessFlags.STR_PROTECTED);
    Checkbox	isPrivate	= new Checkbox(AccessFlags.STR_PRIVATE);
    Checkbox	isStatic	= new Checkbox(AccessFlags.STR_STATIC);
    Checkbox	isAbstract	= new Checkbox(AccessFlags.STR_ABSTRACT);
    Checkbox	isFinal		= new Checkbox(AccessFlags.STR_FINAL);
    Checkbox	isNative	= new Checkbox(AccessFlags.STR_NATIVE);
    Checkbox	isSynchronized	= new Checkbox(AccessFlags.STR_SYNCHRONIZED);

    public NewMethodDialog(Frame f, CodePath cp, ClassSpec cs, boolean isConstructor) {
	super(f, "new " + (isConstructor ? "constructor" : "method") +
		 " for " + cs.typeAsString() + " " + cs.className());
	frame = f;
	classSpec = cs;
	if (isConstructor) {
	    newConstructor();
	} else {
	    newMethod();
	}
    }

    public NewMethodDialog() {
	super(frame = Transcript.getDefaultFrame(), "new class method");
	classSpec = new ClassSpec("test", null, null, false);
	newMethod();
	pack();
    }

    void newConstructor() {
	Panel modifiers = new Panel();
	modifiers.setLayout(new FlowLayout(FlowLayout.LEFT));
	modifiers.add(isPublic);
	modifiers.add(isProtected);
	modifiers.add(isPrivate);

	methodName = new TextField(classSpec.className());
	methodName.setEditable(false);

	Panel argumentsPanel = new Panel();
	argumentsPanel.setLayout(new BorderLayout());
	argumentsPanel.add("West", new Label(" ("));
	argumentsPanel.add("Center", arguments);
	argumentsPanel.add("East", new Label(")"));

	Panel methodPanel = new Panel();
	methodPanel.setLayout(new BorderLayout());
	methodPanel.add("West", methodName);
	methodPanel.add("Center", argumentsPanel);

	Panel labels = new Panel();
	labels.setLayout(new GridLayout(3, 1));
	labels.add(new Label(     "modifiers : ", Label.RIGHT));
	labels.add(new Label("name/arguments : ", Label.RIGHT));
	labels.add(new Label(        "throws : ", Label.RIGHT));

	Panel fields = new Panel();
	fields.setLayout(new GridLayout(3, 1));
	fields.add(modifiers);
	fields.add(methodPanel);
	fields.add(throwsField);

	Panel centerPanel = new Panel();
	centerPanel.setLayout(new BorderLayout());
	centerPanel.add("West", labels);
	centerPanel.add("Center", fields);

	add("Center", centerPanel);
    }

    void newMethod() {
	Panel modifiers1 = new Panel();
	modifiers1.setLayout(new FlowLayout(FlowLayout.LEFT));
	Panel modifiers2 = null;
	if (classSpec.isInterface()) {
	    modifiers1.add(isPublic);
	    isAbstract.setState(true);
	} else {
	    modifiers1.add(isPublic);
	    modifiers1.add(isProtected);
	    modifiers1.add(isPrivate);

	    modifiers2 = new Panel();
	    modifiers2.setLayout(new FlowLayout(FlowLayout.LEFT));
	    modifiers2.add(isStatic);
	    modifiers2.add(isAbstract);
	    modifiers2.add(isFinal);
	    modifiers2.add(isNative);
	    modifiers2.add(isSynchronized);
	}

	primitiveType = new Choice();
	primitiveType.addItem("");
	primitiveType.addItem("void");
	primitiveType.addItem("boolean");
	primitiveType.addItem("char");
	primitiveType.addItem("byte");
	primitiveType.addItem("short");
	primitiveType.addItem("int");
	primitiveType.addItem("long");
	primitiveType.addItem("float");
	primitiveType.addItem("double");
	primitiveType.addItem("String");
	primitiveType.addItem("Object");
	primitiveType.addItem("Hashtable");
	primitiveType.addItem("Vector");
	primitiveType.addItem("Enumeration");

	objectType = new TextField(12);

	Panel returnType = new Panel();
	returnType.setLayout(new BorderLayout());
	returnType.add("West", primitiveType);
	returnType.add("Center", objectType);

	methodName = new TextField(12);

	Panel argumentsPanel = new Panel();
	argumentsPanel.setLayout(new BorderLayout());
	argumentsPanel.add("West", new Label(" ("));
	argumentsPanel.add("Center", arguments);
	argumentsPanel.add("East", new Label(")"));

	Panel nameAndArguments = new Panel();
	nameAndArguments.setLayout(new BorderLayout());
	nameAndArguments.add("West", methodName);
	nameAndArguments.add("Center", argumentsPanel);

	arrayChoice = new Choice();
	arrayChoice.addItem("");
	arrayChoice.addItem("[]");
	arrayChoice.addItem("[][]");
	arrayChoice.addItem("[][][]");
	arrayChoice.addItem("[][][][]");
	arrayChoice.addItem("[][][][][]");

	Panel arrayPanel = new Panel();
	arrayPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
	arrayPanel.add(arrayChoice);

	Panel labels = new Panel();
	labels.setLayout(new GridLayout(modifiers2 == null? 5 : 6,1));
	labels.add(new Label(     "modifiers : ", Label.RIGHT));
	if (modifiers2 != null) {
	    labels.add(new Label(             "", Label.RIGHT));
	}
	labels.add(new Label(   "return type : ", Label.RIGHT));
	labels.add(new Label("name/arguments : ", Label.RIGHT));
	labels.add(new Label(        "arrays : ", Label.RIGHT));
	labels.add(new Label(        "throws : ", Label.RIGHT));

	Panel fields = new Panel();
	fields.setLayout(new GridLayout(modifiers2 == null? 5 : 6, 1));
	fields.add(modifiers1);
	if (modifiers2 != null) {
	    fields.add(modifiers2);
	}
	fields.add(returnType);
	fields.add(nameAndArguments);
	fields.add(arrayPanel);
	fields.add(throwsField);

	Panel center = new Panel();
	center.setLayout(new BorderLayout());
	center.add("West", labels);
	center.add("Center", fields);

	add("Center", center);
    }

    public MethodSpec getMethodSpec() {
	return methodSpec;
    }

    public String getDescription() {
	return description.toString();
    }

    public boolean action(Event ev, Object arg) {
	if (primitiveType != null && ev.target == primitiveType) {
	    objectType.setText("");
	    return false;
	} else if (objectType != null && ev.target == objectType) {
	    primitiveType.select(0);
	    return false;
	}
	return super.action(ev, arg);
    }

    public void actionLeftButton() {
	String mn = methodName.getText().trim();
	if (mn.length() == 0) {
	    DejavaDialog.information(this, "method name required");
	    return;
	}
	int illegal = JavaLexical.isIdentifier(mn);
	if (illegal >= 0) {
	    DejavaDialog.information(this, "illegal character '" +
					   mn.charAt(illegal) +
					   "' for method name");
	    return;
	}
	description.setLength(0);
	description.append(getCheckbox(isPublic));
	description.append(getCheckbox(isProtected));
	description.append(getCheckbox(isPrivate));
	description.append(getCheckbox(isStatic));
	description.append(getCheckbox(isAbstract));
	description.append(getCheckbox(isFinal));
	description.append(getCheckbox(isNative));
	description.append(getCheckbox(isSynchronized));
	if (primitiveType != null) {
	    String returnType = objectType.getText().trim();
	    if (returnType.length() == 0) {
		returnType = primitiveType.getSelectedItem();
	    }
	    if (returnType != null) {
		description.append(returnType);
		description.append(' ');
	    }
	}
	description.append(methodName.getText());
	description.append('(');
	description.append(arguments.getText());
	description.append(')');
	if (arrayChoice != null) {
	    String array = arrayChoice.getSelectedItem();
	    if (array != null) description.append(array);
	}
	String throwsList = throwsField.getText().trim();
	if (throwsList.length() > 0) {
		description.append(" throws ");
		description.append(throwsList);
	}
	try {
	    methodSpec = new MethodSpec(description.toString() + " ",
				        classSpec.className());
	} catch (DescriptionException e) {
	    DejavaDialog.information(frame, e.getMessage());
	    return;
	}
	super.actionLeftButton();
    }

    String getCheckbox(Checkbox checkbox) {
	if (checkbox.getState()) {
	    return checkbox.getLabel() +  " ";
	} else {
	    return "";
	}
    }

    public static void main(String args[]) {
	new NewMethodDialog().show();
    }
}
