/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.*;
import dejava.lang.JavaLexical;

class NewPackageDialog extends DejavaDialog {
    String name;

    NewPackageDialog(Frame frame) {
	super(frame, "new package", "");
    }

    public void actionLeftButton() {
	name = getText().trim();
	if (name.length() == 0) return;
	int illegal = JavaLexical.isIdentifier(name, ".");
	if (illegal >= 0) {
	    DejavaDialog.information(this, "illegal character '" +
					   name.charAt(illegal) +
					   "' for package name");
	    return;
	}
	super.actionLeftButton();
    }

    public String getName() {
	return name;
    }
}
