/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.gui;

import java.awt.*;

import dejava.sys.*;
import dejava.lang.JavaLexical;
import dejava.gui.DejavaDialog;
import dejava.gui.DejavaFileDialog;

class NewProjectDialog extends DejavaFileDialog {

    TextField name;
    Checkbox  rebuildCheck;

    String projectName;
    String projectPath;
    boolean  rebuildNow;

    public NewProjectDialog(Transcript transcript) {
	super(transcript, "Add New Project");
    }

    public void createDisplayItems() {
	Panel labels = new Panel();
	labels.setLayout(new GridLayout(3, 1));
	labels.add(new Label("project name:", Label.RIGHT));
	labels.add(new Label("project path:", Label.RIGHT));
	labels.add(new Label("rebuild database now:", Label.RIGHT));

	Panel fileArea = new Panel();
	fileArea.setLayout(new BorderLayout());
	fileArea.add(CENTER, path);
	fileArea.add(EAST, choose);

	Panel values = new Panel();
	values.setLayout(new GridLayout(3, 1));
	values.add(name = new TextField(30));
	values.add(fileArea);
	values.add(rebuildCheck = new Checkbox(""));

	Panel rebuild = new Panel();
	rebuild.setLayout(new BorderLayout());

	Panel spec = new Panel();
	spec.setLayout(new BorderLayout());
	spec.add(WEST,   labels);
	spec.add(CENTER, values);

	add(CENTER, spec);
    }

    public String projectName() {
	return projectName;
    }

    public String projectPath() {
	return projectPath;
    }

    public boolean rebuildNow() {
	return rebuildNow;
    }

    public void actionLeftButton() {
	projectName = name.getText().trim();
	int illegal = JavaLexical.isIdentifier(projectName);
	if (illegal >= 0) {
	    DejavaDialog.information(this, "illegal character '" +
					   projectName.charAt(illegal) +
					   "' for project name");
	    return;
	}
	if (projectName.length() == 0) return;
	projectPath = getPath().trim();
	if (projectPath.length() == 0) return;

	rebuildNow = rebuildCheck.getState();
	super.actionLeftButton();
    }
}
