/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.gui;

import java.awt.*;

import dejava.gui.FocusDialog;

class Replacer extends FocusDialog {
    protected TextArea target;
    protected boolean forward = true;

    protected TextField searchStringField;
    protected TextField replaceStringField;

    protected final static String BACKWORD    = "<< backword";
    protected final static String FORWARD     = "forward >>";
    protected final static String NEXT	      = "next";
    protected final static String REPLACENEXT = "replace & next";
    protected final static String REPLACESTAY = "replace & stay";
    protected final static String REPLACEALL  = "replace all";
    protected final static String CLOSE       = "done";

    protected Button replaceNext;
    protected Button replaceStay;
    protected Button replaceAll;

    Replacer(Frame frame, TextArea target) {
	super(frame, false);
	this.target = target;

	Panel labels = new Panel();
	labels.setLayout(new GridLayout(2, 1));
	labels.add(new Label( "search string:", Label.RIGHT));
	labels.add(new Label("replace string:", Label.RIGHT));
	
	Panel fields = new Panel();
	fields.setLayout(new GridLayout(2, 1));
	fields.add(searchStringField  = new TextField(30));
	fields.add(replaceStringField = new TextField(30));
	searchStringField.setText(target.getSelectedText());

	Panel text = new Panel();
	text.setLayout(new BorderLayout());
	text.add("West", labels);
	text.add("Center", fields);

	Panel replace = new Panel();
	replace.setLayout(new GridLayout(4, 1));
	replace.add(new DejavaButton(NEXT));
	replace.add(replaceStay = new DejavaButton(REPLACESTAY));
	replace.add(replaceNext = new DejavaButton(REPLACENEXT));
	replace.add(replaceAll  = new DejavaButton(REPLACEALL ));

	Panel buttons = new Panel();
	buttons.setLayout(new BorderLayout());
	buttons.add("West",   new DejavaButton(BACKWORD));
	buttons.add("Center", replace);
	buttons.add("East",   new DejavaButton(FORWARD));

	Panel close = new Panel();
	close.setLayout(new BorderLayout());
	close.add("Center", new DejavaButton(CLOSE));

	setLayout(new BorderLayout());
	add("North" , text);
	add("Center", buttons);
	add("South" , close);

    }

    void setSearchString(String searchString) {
	searchStringField.setText(searchString);
    }

    public void show() {
	super.show();
	Rectangle parent = getParent().bounds();
	Dimension me = size();
	move(parent.x + (parent.width  - me.width ) / 2, parent.y + 40);
    }

    public void hide() {
	searchStringField.setText("");
	replaceStringField.setText("");
	super.hide();
    }

    public void updateActibity() {
	if (target.isEditable()) {
	    replaceStringField.setEditable(true);
	    replaceStay.enable();
	    replaceNext.enable();
	    replaceAll.enable();
	} else {
	    replaceStringField.setEditable(false);
	    replaceStay.disable();
	    replaceNext.disable();
	    replaceAll.disable();
	}
    }

    public boolean action(Event ev, Object arg) {
	if (ev.target == searchStringField ||
	    ev.target == replaceStringField) {
	    next();
	    return false;
	} else if (ev.target instanceof Button) {
	    String button = (String)arg;
	    if (button.equals(BACKWORD)) {
		backword();
	    } else if (button.equals(FORWARD)) {
		forward();
	    } else if (button.equals(NEXT)) {
		next();
	    } else if (button.equals(REPLACENEXT)) {
		replace(true);
	    } else if (button.equals(REPLACESTAY)) {
		replace(false);
	    } else if (button.equals(REPLACEALL)) {
		replaceAll();
	    } else if (button.equals(CLOSE)) {
		close();
	    } else {
		return super.action(ev, arg);
	    }
	    return true;
	}
	return super.action(ev, arg);
    }

    protected boolean next() {
	if (forward) {
	    return forward();
	} else {
	    return backword();
	}
    }

    protected boolean backword() {
	forward = false;

	int cursor = target.getSelectionStart();
	if (cursor <= 0) return false;

	String searchString = searchStringField.getText();
	if (searchString.length() == 0) return false;

	String code = target.getText();
	int index = code.lastIndexOf(searchString, cursor - 1);
	if (index < 0) {
	    target.select(0, 0);
	    return false;
	} else {
	    target.select(index, index + searchString.length());
	    return true;
	}
    }

    protected boolean forward() {
	forward = true;

	String searchString = searchStringField.getText();
	if (searchString.length() == 0) return false;

	String code = target.getText();
	int length = code.length();

	int cursor = target.getSelectionEnd();
	if (cursor >= length) return false;

	int index = code.indexOf(searchString, cursor);
	if (index < 0) {
	    target.select(length, length);
	    return false;
	} else {
	    target.select(index, index + searchString.length());
	    return true;
	}
    }

    protected boolean replace(boolean next) {
	if (!target.isEditable()) return false;

	int selectionStart = target.getSelectionStart();
	int selectionEnd   = target.getSelectionEnd();
	if (selectionStart != selectionEnd) {
	    String replaceString = replaceStringField.getText();
	    target.replaceText(replaceString, selectionStart, selectionEnd);
	    if (forward) selectionStart += replaceString.length();
	    target.select(selectionStart, selectionStart);
	}

	if (next) {
	    return next();
	} else {
	    return false;
	}
    }

    protected void replaceAll() {
	while (replace(true));
    }

    protected void close() {
	hide();
    }
}
