/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.gui;

import dejava.sys.*;
import dejava.lang.*;
import dejava.util.*;
import java.util.Enumeration;

class SendersFrame extends GrepFrame {
    MethodSpec mspec;

    static void openOn(CodePath cp) throws DejavaException {
	SendersFrame frame = new SendersFrame(cp, cp.methodManager().spec());
	frame.open();
	frame.start();
    }

    SendersFrame(CodePath cp, MethodSpec mspec) throws DejavaException {
	this(cp, mspec.methodName(), mspec.prototype());
	this.mspec = mspec;
    }

    SendersFrame(CodePath cp, String name, String title) throws DejavaException {
	super(cp, "[^a-zA-Z_0-9]" + name + "[ \t(]", title);
    }

    protected void initialize(CodePath cp, String pattern, String title)
    throws DejavaException {
	//super.initialize(cp.projectCodePath(), pattern, title);
	super.initialize(CodePath.nullCodePath, pattern, title);
	super.showPattern(false);
    }

    protected boolean addItem(ListItem item) {
	CodePath cp = item.codePath();
	MethodManager methodManager = cp.methodManager();
	int argCount = 0;
	String arguments = mspec.arguments();
	int length = arguments.length();
	if (length > 0) {
	    argCount = 1;			// at least one argument
	    for (int i = 0; i < length; i++) {
		if (arguments.charAt(i) == ',') argCount++;
	    }
	}
	if (methodManager != null) {
	    try {
		Enumeration ids = methodManager.messages();
		while (ids.hasMoreElements()) {
		    IdentifierSpec idspec = (IdentifierSpec)ids.nextElement();
		    if (idspec.name().equals(mspec.methodName()) &&
			idspec.isMethod() >= IdentifierSpec.MAYBE &&
			((1L << argCount) & idspec.argumentCountBits()) >= 0) {
			// maybe same method
			super.addItem(item);
			return true;
		    }
		}
	    } catch (DescriptionException e) {
	    }
	}
	return false;
    }
}
