/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.lang;

import java.util.Enumeration;

/**
 * specification of identifier
 */
public class IdentifierSpec implements Enumeration {
    public static final byte NEVER  = -1;
    public static final byte MAYBE  =  0;
    public static final byte MUST   =  1;

    private byte isClass = NEVER;
    private byte isMethod = NEVER;
    private byte isVariable;
    private byte isLabel;
    private byte isLocalMember = NEVER;

    private String name;
    private long argumentCountBits = 0;
    private int maskPosition;

    /**
     * the constructor
     */
    IdentifierSpec(String name) {
	this.name = name;
    }

    /**
     * 
     */
    private void setNeverToAll() {
	isClass    = NEVER;
	isMethod   = NEVER;
	isVariable = NEVER;
	isLabel    = NEVER;
    }

    /**
     *
     */
    void mustBeClass() {
	setNeverToAll();
	isClass = MUST;
    }

    /**
     *
     */
    void mustBeMethod() {
	setNeverToAll();
	isMethod = MUST;
    }

    /**
     *
     */
    void mustBeVariable() {
	setNeverToAll();
	isVariable = MUST;
    }

    /**
     *
     */
    void mustBeLabel() {
	setNeverToAll();
	isLabel = MUST;
    }

    /**
     *
     */
    void mustBeLocalMember() {
	isLocalMember = MUST;
    }

    /**
     *
     */
    void mayBeClass() {
	isVariable = NEVER;
	isLabel    = NEVER;
	isClass    = MAYBE;
    }

    /**
     *
     */
    void mayBeMethod() {
	isVariable = NEVER;
	isLabel    = NEVER;
	isMethod   = MAYBE;
    }

    /**
     *
     */
    public String name() {
	return name;
    }

    /**
     * enumerate all method names
     */
    public Enumeration names() {
	maskPosition = 0;
	return this;
    }

    /**
     *
     */
    public byte isClass() {
	return isClass;
    }

    /**
     *
     */
    public byte isMethod() {
	return isMethod;
    }

    /**
     *
     */
    public byte isVariable() {
	return isVariable;
    }

    /**
     *
     */
    public byte isLabel() {
	return isLabel;
    }

    /**
     * check argument count and add it if it has not been registered
     */
    void addNewArgumentCount(int argumentCount) {
	argumentCountBits |= (1L << argumentCount);
    }

    public long argumentCountBits() {
	return argumentCountBits;
    }

    /**
     * java.util.Enumeration stuff
     */
    public boolean hasMoreElements() {
	return (argumentCountBits >= (1L << maskPosition));
    }

    /**
     * java.util.Enumeration stuff
     */
    public Object nextElement() {
	long bit = 1L << maskPosition;
	while ((bit & argumentCountBits) == 0) {
	    bit <<= 1;
	    maskPosition++;
	}
	String args = "";
	if (maskPosition > 0) {
	    args = args + maskPosition;
	}
	maskPosition++;
	return name + "(" + args + ")";
    }
}
