/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.lang;

import dejava.sys.SystemManager;
import java.util.*;

public class IdentifiersInCode {
    CodeReader reader;
    Stack methodStack = new Stack();
    Stack countStack = new Stack();
    int index;

    /**
     * holds IdentifierSpec-s
     */
    Hashtable identifiers = new Hashtable();
    private static final Hashtable keywords = new Hashtable();
    private static final String keywordStrings[] = {
	"void",
	"boolean",
	"char",
	"byte",
	"short",
	"int",
	"long",
	"float",
	"double",

	"null",
	"true",
	"false",

	// "this",
	// "super",

	"class",
	"interface",
	"extends",
	"implements",
	"throws",

	"package",
	"import",

	"if",
	"else",
	"while",
	"for",
	"do",
	"switch",
	"case",
	"default",
	"break",
	"continue",
	"try",
	"catch",
	"finally",
	"throw",
	"return",

	"new",
	"instanceof",

	"synchronized",
	"abstract",
	"native",
	"public",
	"protected",
	"private",
	"final",
	"threadsafe",
	"transient",
	"volatile",

	"goto",
	"const",
	"byvalue",
    };

    static {
	for (int i = 0; i < keywordStrings.length; i++) {
	   keywords.put(keywordStrings[i], keywordStrings[i]);
	}
    }

    /**
     * the constructer
     */
    public IdentifiersInCode(String code)
    throws dejava.lang.DescriptionException {
	reader = new CodeReader(code, Integer.MAX_VALUE, true);
	pickUpIdentifiers();
    }

    /**
     * pick up all identifiers in given code
     */
    private void pickUpIdentifiers() throws DescriptionException {
	if (reader.nextDescription() == 0) {
	    // has no body
	    return;
 	}
	int parenLevel = 0;
	int argumentCount = 0;
	IdentifierSpec idspec = null;
	while (reader.nextDescription() > 0) {
	    String sentence = reader.description();
	    int length = sentence.length();
	    index = 0;
	    char predelim = '\0';
	    for (index = 0; index < length; index++) {
		char c = sentence.charAt(index);
		if (Character.isSpace(c)) continue;
		switch (c) {
		case '"':		// beggining of String
		    while (++index < length) {
			c = sentence.charAt(index);
			if (c == '\\') index++;
			else if (c == '"') break;
		    }
		    break;
		case '\'':
		    while (++index < length) {
			c = sentence.charAt(index);
			if (c == '\\') index++;
			else if (c == '\'') break;
		    }
		    break;
		case ',':
		    argumentCount++;
		    break;
		case '(':
		    parenLevel++;
		    break;
		case ')':
		    parenLevel--;
		    if (parenLevel == -1) {	// end of message passing
			if (idspec != null) {
			    idspec.addNewArgumentCount(predelim == '(' ? 0 : argumentCount + 1);
			    if (!methodStack.empty()) {
				idspec = (IdentifierSpec)methodStack.pop();
			    } else {
				idspec = null;
			    }
			    argumentCount = ((Integer)countStack.pop()).intValue();
			    parenLevel = ((Integer)countStack.pop()).intValue();
			} else {
			    SystemManager.messageln("Internal error: too much ')': " + sentence);
			}
		    }
		    break;
		default:
		    if (Character.isLowerCase(c) ||
			Character.isUpperCase(c) ||
			c == '_') {
			int start = index;
			while (++index < length) {
			    c = sentence.charAt(index);
			    if (!Character.isLowerCase(c) &&
				!Character.isUpperCase(c) &&
				!Character.isDigit(c) && c != '_') {
				    break;
			    }
			}
			IdentifierSpec newIdspec =
			    found(sentence, start, index, predelim, (index == length) ? '\0' : c);
			if (newIdspec != null) {
			    if (idspec != null) {
			        methodStack.push(idspec);
			    }
			    countStack.push(new Integer(parenLevel));
			    countStack.push(new Integer(argumentCount));
			    parenLevel = 0;
			    argumentCount = 0;
			    idspec = newIdspec;
			} else {
			    index--;		// push back delimiter
			}
		    }
		}
		predelim = c;
	    }
	}
    }

    /**
     * pick up all identifiers in given code
     * returns true if identifier is a method name
     */
    private IdentifierSpec found(String sentence, int start, int end,
			char predelim, char postdelim) {
	String key = sentence.substring(start, end );
	if (!keywords.containsKey(key)) {
	    IdentifierSpec idspec;
	    if (identifiers.containsKey(key)) {
		idspec = (IdentifierSpec)identifiers.get(key);
	    } else {
		idspec = new IdentifierSpec(key);
	        identifiers.put(key, idspec);
	    }
	    if (predelim != '.') {
		idspec.mustBeLocalMember();
		idspec.mayBeClass();
	    }
	    switch (postdelim) {
	    case '(':
		idspec.mustBeMethod();
		return idspec;
	    case ',':
		idspec.mustBeVariable();
		break;
	    case ':':
		idspec.mustBeLabel();
		break;
	    }
	}
	return null;
    }

    /**
     * sort identifiers appeared in the code and return enumeration of them
     */
    public Enumeration identifiers() {
	Vector sorted = new Vector(identifiers.size());
	Enumeration en = identifiers.elements();
	while (en.hasMoreElements()) {
	    IdentifierSpec spec = (IdentifierSpec)en.nextElement();
	    int i = 0;
	    while (i < sorted.size()) {
		String name = ((IdentifierSpec)sorted.elementAt(i)).name();
		if (name.compareTo(spec.name()) >= 0) break;
		i++;
	    }
	    sorted.insertElementAt(spec, i);
	}
	return sorted.elements();
    }
}
