package dejava.lang;

public class JavaLexical {

    public static int isIdentifier(String name) {
	return isIdentifier(name, 0, name.length());
    }

    public static int isIdentifier(String name, String with) {
	int pos = 0;
	int length = name.length();
	int illegal;
	while ((illegal = isIdentifier(name, pos, length)) >= 0) {
	    if (with.indexOf(name.charAt(illegal)) < 0) return illegal;
	    pos++;
	}
	return -1;
    }

    public static int isIdentifier(String name, int pos, int length) {
	if (length == 0) return -1;
	if (pos == 0 && !isUnicodeLetter(name.charAt(0))) return 0;
	for (int i = pos; i < length; i++) {
	    char c = name.charAt(i);
	    if (!isUnicodeLetter(c) && !isUnicodeDigit(c)) return i;
	}
	return -1;
    }

    public static boolean isUnicodeLetter(char c) {
	if ('\u0041' <= c && c <= '\u005a') return true;
	if ('\u0061' <= c && c <= '\u007a') return true;
	if (c == '_' || c == '$') return true;
	if ('\u00c0' <= c && c <= '\u00d6') return true;
	if ('\u00d8' <= c && c <= '\u00f6') return true;
	if ('\u00f8' <= c && c <= '\u00ff') return true;
	if ('\u0100' <= c && c <= '\u1fff') return true;
	if ('\u3040' <= c && c <= '\u318f') return true;
	if ('\u3300' <= c && c <= '\u337f') return true;
	if ('\u3400' <= c && c <= '\u3d2d') return true;
	if ('\u4e00' <= c && c <= '\u9fff') return true;
	if ('\uf900' <= c && c <= '\ufaff') return true;
	return false;
    }

    public static boolean isUnicodeDigit(char c) {
	if ('\u0030' <= c && c <= '\u0039') return true;
	if ('\u0660' <= c && c <= '\u0669') return true;
	if ('\u06f0' <= c && c <= '\u06f9') return true;
	if ('\u0966' <= c && c <= '\u096f') return true;
	if ('\u09e6' <= c && c <= '\u09ef') return true;
	if ('\u0a66' <= c && c <= '\u0a6f') return true;
	if ('\u0ae6' <= c && c <= '\u0aef') return true;
	if ('\u0b66' <= c && c <= '\u0b6f') return true;
	if ('\u0be7' <= c && c <= '\u0bef') return true;
	if ('\u0c66' <= c && c <= '\u0c6f') return true;
	if ('\u0ce6' <= c && c <= '\u0cef') return true;
	if ('\u0d66' <= c && c <= '\u0d6f') return true;
	if ('\u0e50' <= c && c <= '\u0e59') return true;
	if ('\u0ed0' <= c && c <= '\u0ed9') return true;
	if ('\u1040' <= c && c <= '\u1049') return true;
	return false;
    }

    public static void main(String args[]) {
	if (args.length > 0)
	    System.out.println(isIdentifier(args[0]));
    }
}
