package dejava.lang;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Hashtable;

public class MethodPrototype implements Enumeration {
    int index = 0;
    private final static Hashtable prototypeTable = new Hashtable();

    private final static String methodPrototype[][] = {
	{ "main",
	  "public static void main(String args[])",
	  "It is called automatically by the system the application is started."
	},
	{ null, null, null },
	{ "init",
	  "public void init()",
	  "Initializes the applet.\n" +
	  "You never need to call this directly, it is called automatically\n" +
	  "by the system once the applet is created.\n" +
	  "@see java.applet.Applet#init"
	},
	{ "start",
	  "public void start()",
	  "Called to start the applet. You never need to call this method\n" +
	  "directly, it is called when the applet's document is visited.\n" +
	  "@see java.applet.Applet#start"
	},
	{ "stop",
	  "public void stop()",
	  "Called to stop the applet. It is called when the applet's document is\n" +
	  "no longer on the screen. It is guaranteed to be called before destroy()\n" +
	  "is called. You never need to call this method directly.\n" +
	  "@see java.applet.Applet#stop"
	},
	{ "destroy",
	  "public void destroy()",
	  "Cleans up whatever resources are being held. If the applet is active\n" +
	  "@see java.applet.Applet#destroy"
	},
	{ null, null, null },
	{ "paint",
	  "public void paint(Graphics g)",
	  "Paints the component.\n" +
	  "@param g the specified Graphics window\n" +
	  "@see java.awt.Component#paint"
	},
	{ "update",
	  "public void update(Graphics g)",
	  "Updates the component. This method is called in\n" +
	  "response to a call to repaint. You can assume that\n" +
	  "the background is not cleared.\n" +
	  "@param g the specified Graphics window\n" +
	  "@see java.awt.Component#update"
	},
	{ "imageUpdate",
	  "public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height)",
 	  "This method is called when information about an image which was\n" +
	  "previously requested using an asynchronous interface becomes\n" +
	  "available.  Asynchronous interfaces are method calls such as\n" +
	  "getWidth(ImageObserver) and drawImage(img, x, y, ImageObserver)\n" +
	  "which take an ImageObserver object as an argument.  Those methods\n" +
	  "register the caller as interested either in information about\n" +
	  "the overall image itself (in the case of getWidth(ImageObserver))\n" +
	  "or about an output version of an image (in the case of the\n" +
	  "drawImage(img, x, y, [w, h,] ImageObserver) call).  This method\n" +
	  "should return true if further updates are needed or false if the\n" +
	  "required information has been acquired.  The image which was being\n" +
	  "tracked is passed in using the img argument.  Various constants\n" +
	  "are combined to form the infoflags argument which indicates what\n" +
	  "information about the image is now available.  The interpretation\n" +
	  "of the x, y, width, and height arguments depends on the contents\n" +
	  "of the infoflags argument.\n" +
	  "@see java.awt.image.ImageObserver#imageUpdate"
	},
	{ null, null, null },
	{ "handleEvent",
	  "public boolean handleEvent(Event evt)",
	  "Handles the event. Returns true if the event is handled and\n" +
	  "should not be passed to the parent of this component. The default\n" +
	  "event handler calls some helper methods to make life easier\n" +
	  "on the programmer.\n" +
	  "@param evt the event\n" +
	  "@see java.awt.Component#handleEvent"
	},
	{ "mouseDown",
	  "public boolean mouseDown(Event evt, int x, int y)",
	  "Called if the mouse is down.\n" +
	  "@param evt the event\n" +
	  "@param x the x coordinate\n" +
	  "@param y the y coordinate\n" +
	  "@see java.awt.Component#mouseDown"
	},
	{ "mouseDrag",
	  "public boolean mouseDrag(Event evt, int x, int y)",
	  "Called if the mouse is dragged (the mouse button is down)\n" +
	  "@param evt the event\n" +
	  "@param x the x coordinate\n" +
	  "@param y the y coordinate\n" +
	  "@see java.awt.Component#mouseDrag"
	},
	{ "mouseUp",
	  "public boolean mouseUp(Event evt, int x, int y)",
	  "Called if the mouse is up.\n" +
	  "@param evt the event\n" +
	  "@param x the x coordinate\n" +
	  "@param y the y coordinate\n" +
	  "@see java.awt.Component#mouseUp"
	},
	{ "mouseMove",
	  "public boolean mouseMove(Event evt, int x, int y)",
	  "Called if the mouse moves (the mouse button is up)\n" +
	  "@param evt the event\n" +
	  "@param x the x coordinate\n" +
	  "@param y the y coordinate\n" +
	  "@see java.awt.Component#mouseMove"
	},
	{ "mouseEnter",
	  "public boolean mouseEnter(Event evt, int x, int y)",
	  "Called when the mouse enters the component.\n" +
	  "@param evt the event\n" +
	  "@param x the x coordinate\n" +
	  "@param y the y coordinate\n" +
	  "@see java.awt.Component#mouseEnter"
	},
	{ "mouseExit",
	  "public boolean mouseExit(Event evt, int x, int y)",
	  "Called when the mouse exits the component.\n" +
	  "@param evt the event\n" +
	  "@param x the x coordinate\n" +
	  "@param y the y coordinate\n" +
	  "@see java.awt.Component#mouseExit"
	},
	{ "keyDown",
	  "public boolean keyDown(Event evt, int key)",
	  "Called if a character is pressed.\n" +
	  "@param evt the event\n" +
	  "@param key the key that's pressed\n" +
	  "@see java.awt.Component#keyDown"
	},
	{ "keyUp",
	  "public boolean keyUp(Event evt, int key)",
	  "Called if a character is released.\n" +
	  "@param evt the event\n" +
	  "@param key the key that's released\n" +
	  "@see java.awt.Component#keyUp"
	},
	{ "action",
	  "public boolean action(Event evt, Object what)",
	  "Called if an action occurs in the Component\n" +
	  "@param evt the event\n" +
	  "@param what the action that's occuring\n" +
	  "@see java.awt.Component#action"
	 },
    };

    static {
	for (int i = 0; i < methodPrototype.length; i++) {
	    String prototype = methodPrototype[i][0];
	    if (prototype != null) prototypeTable.put(prototype, new Integer(i));
	}
    }

    public boolean hasMoreElements()  {
	return index < methodPrototype.length;
    }

    public Object nextElement()  {
	if (index < methodPrototype.length) {
	    return methodPrototype[index++][0];
	}
	throw new NoSuchElementException("MethodPrototype");
    }

    public static String getDescription(String name)  {
	StringBuffer code = new StringBuffer();
	int index = ((Integer)prototypeTable.get(name)).intValue();
	String comment = methodPrototype[index][2];
	if (comment != null) {
	    code.append("    /**\n");
	    int bol = 0;
	    int next;
	    while ((next = comment.indexOf('\n', bol) + 1) > 0) {
		code.append("     * ");
		code.append(comment.substring(bol, next));
		bol = next;
	    }
	    if (bol < comment.length()) {
		code.append("     * ");
		code.append(comment.substring(bol));
		code.append("\n");
	    }
	    code.append("     */\n");
	}
	code.append("    ");
	code.append(methodPrototype[index][1]);
	code.append(" {\n    }\n");
	return code.toString();
    }
}
