package dejava.sys;

import java.io.*;

public class DejavaFile extends File {
    private static final boolean useRename = SystemManager.onSolaris;

    public DejavaFile(String path) {
        super(path);
    }

    public DejavaFile(String path, String name) {
        super(path, name);
    }

    public DejavaFile(File dir, String name) {
        super(dir, name);
    }

    /*
     * for Win32 platforms:
     * They didn't override existing file, so we must copy all contents ;-<
     */
    public boolean renameTo(File dest){
	if (!exists()) return false;
	if (dest.exists()) dest.delete();
	return super.renameTo(dest);
    }
}
