package dejava.sys;

import java.util.Properties;
import java.awt.Font;
import java.io.*;

/*
 * system properties for dejava
 */
public class DejavaProperties {
    private static final Properties defprops =
		new Properties(System.getProperties());
    private static final Properties props = new Properties();
    private static final String defaults[][] = {
    // fonts
	/*
	{"font.menu.name",		"Fixed"},
	{"font.list.name",		"Fixed"},
	{"font.code.name",		"Fixed"},
	{"font.button.name",		"Fixed"},
	*/
	{"font.dialog.name",		"Dialog"},
	{"font.default.name",		"Courier"},
	{"font.default.face",		new Integer(Font.PLAIN).toString()},
	{"font.default.size",		"14"},

    // external commands
	{"command.java", 		"%java.home%/bin/java" },
	{"command.javac", 		"%java.home%/bin/javac" },

    // list item visibility
	{"show.class.public",		"true"},
	{"show.class.friendly",		"true"},
	{"show.method.public",		"true"},
	{"show.method.protected",	"true"},
	{"show.method.priv-protected",	"true"},
	{"show.method.friendly",	"true"},
	{"show.method.private",		"true"},

    // display attribute
	{"attribute.available",		"false"},
	{"attribute.list.foreground",	"black"},
	{"attribute.list.background",	"lightgray"},
	{"attribute.list.class",	"Plain"},
	{"attribute.list.interface",	"Italic"},
	{"attribute.list.public",	"black"},
	{"attribute.list.protected",	"black"},
	{"attribute.list.priv-protected","black"},
	{"attribute.list.friendry",	"black"},
	{"attribute.list.private",	"gray"},

	{"attribute.code.keyword",	"Bold"},
	{"attribute.code.class",	"Italic"},

	{"attribute.browsing.lines",	"11"},
	{"attribute.files.lines",	"10"},
	{"attribute.listing.lines",	 "7"},

    // code completion
	{"complete.available",		"false"},
	{"complete.default",		"S-SPC"},
	{"complete.classname",		"S-C-c"},
	{"complete.methodname",		"S-C-m"},
	{"complete.variablename",	"S-C-v"},
    };
    static {
	for (int i = 0; i < defaults.length; i++) {
	    defprops.put(defaults[i][0], defaults[i][1]);
	}
	if (SystemManager.onWin32) {
	    defprops.put("font.menu.name", "Courier");
	    defprops.put("font.list.name", "Corier");
	    defprops.put("font.code.name", "Courier");
	    defprops.put("font.button.name", "Courier");
	} else {
	    defprops.put("font.menu.name", "Fixed");
	    defprops.put("font.list.name", "Fixed");
	    defprops.put("font.code.name", "Fixed");
	    defprops.put("font.button.name", "Fixed");
	}
    }

    /*
     * should not create an instance
     */
    private DejavaProperties() {}

    /**
     * java.util.Properties has a stupid mistake. So I have to writeit all...
     * Loads properties from an InputStream.
     * @param in the input stream
     * @exception IOException Error when reading from input stream.
     */
    public synchronized static void load(InputStream in) throws IOException {
	in = Runtime.getRuntime().getLocalizedInputStream(in);

	int ch = in.read();
	while (true) {
	    switch (ch) {
	      case -1:
		return;

	      case '#':
	      case '!':
		do {
		    ch = in.read();
		} while ((ch >= 0) && (ch != '\n') && (ch != '\r'));
		continue;

	      case '\n':
	      case '\r':
	      case ' ':
	      case '\t':
		ch = in.read();
		continue;
	    }

	    // Read the key
	    StringBuffer key = new StringBuffer();
	    while ((ch >= 0) && (ch != '=') && (ch != ':') && 
		   (ch != ' ') && (ch != '\t') && (ch != '\n') && (ch != '\r')) {
		key.append((char)ch);
		ch = in.read();
	    }
	    while ((ch == ' ') || (ch == '\t')) {
		ch = in.read();
	    }
	    if ((ch == '=') || (ch == ':')) {
		ch = in.read();
	    }
	    while ((ch == ' ') || (ch == '\t')) {
		ch = in.read();
	    }

	    // Read the value
	    StringBuffer val = new StringBuffer();
	    while ((ch >= 0) && (ch != '\n') && (ch != '\r')) {
		if (ch == '\\') {
		    switch (ch = in.read()) {
		      case '\n': 
			while (((ch = in.read()) == ' ') || (ch == '\t'));
			continue;
		      case 't': ch = '\t'; break;
		      case 'n': ch = '\n'; break;
		      case 'r': ch = '\r'; break;
		      case 'u': {
			while ((ch = in.read()) == 'u');
			int d = 0;
		      loop:
			for (int i = 0 ; i < 4 ; i++, ch = in.read()) {
			    switch (ch) {
			      case '0': case '1': case '2': case '3': case '4':
			      case '5': case '6': case '7': case '8': case '9':
				d = (d << 4) + ch - '0';
				break;
			      case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
				d = (d << 4) + 10 + ch - 'a';
				break;
			      case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
				d = (d << 4) + 10 + ch - 'A';
				break;
			      default:
				break loop;
			    }	
			}
			ch = d;
		      }
		    }
		}
		val.append((char)ch);
		ch = in.read();
	    }

	    //System.out.println(key + " = '" + val + "'");
	    props.put(key.toString(), val.toString());
	}
    }

    /**
     * Save properties to an OutputStream. Use the header as
     * a comment at the top of the file.
     */
    public static synchronized void save(OutputStream out, String header) {
	props.save(out, header);
    }

    /**
     * Get String property
     */
    public static String getParsedString(String key, String defaultKey) {
	String name = getString(key, defaultKey);
	if (name != null) {
	    StringBuffer buf = new StringBuffer();
	    int to = 0;
	    int from = 0;
	    while (from < name.length() &&
	        (from = name.indexOf('%', to) + 1) > 0) {
		if (from > to + 1) {
		    buf.append(name.substring(to, from - 1));
	        }
		to = name.indexOf('%', from);
		if (to < from) {
		    System.out.println("Warning: property syntax error: " + name);
		    to = from;
		    break;
		}
		String propKey = name.substring(from, to);
		String value = getString(propKey);
		if (value != null) {
		    buf.append(value);
		} else {
		    // we should do something, but what?
		}
		to = to + 1;
	    }
	    buf.append(name.substring(to));
	    return buf.toString().replace('/', File.separatorChar);
	} else {
	    return name;
	}
    }

    /**
     * Get String property
     */
    public static String getParsedString(String key) {
	return getParsedString(key, null);
    }

    /**
     * Get String property
     */
    public static String getString(String key, String defaultKey) {
	Properties p = props;
	String name = null;
	while (name == null) {
	    name = p.getProperty(key);
	    if (name == null && defaultKey != null) {
		name = p.getProperty(defaultKey);
	    }
	    if (p == props) {
		p = defprops;
	    } else break;
	}
	return name;
    }

    /**
     * Get String property
     */
    public static String getString(String key) {
	return getString(key, null);
    }

    /**
     * Get integer property
     */
    public static int getInteger(String key, String defaultKey) {
	try {
	    return Integer.parseInt(getString(key));	
	} catch (Exception e0) try {
	    return Integer.parseInt(getString(defaultKey));
	} catch (Exception e1) {
	    return 0;
	}
    }

    /**
     * Get integer property
     */
    public static int getInteger(String key) {
	String str = getString(key);
	try {
	    return Integer.parseInt(str);	
	} catch (Exception e) {
	    return 0;
	}
    }

    /**
     * Get font property and return proper Font.
     */
    public static Font getFont(String key, int face) {
	String name = getString(key + ".name", "font.default.name");
	int size = getInteger(key + ".size", "font.default.size");
	
	return new Font(name, face, size);
    }

    /**
     * Get font property and return proper Font.
     */
    public static Font getFont(String key) {
	String name = getString(key + ".name", "font.default.name");
	int face = getInteger(key + ".face", "font.default.face");
	int size = getInteger(key + ".size", "font.default.size");
	
	return new Font(name, face, size);
    }

    /**
     * Test main routine
     */
    public static void main(String args[]) {
	if (args.length > 0) try {
	    load(new FileInputStream(args[0]));
	} catch (IOException e) {}
	for (int i = 0; i < defaults.length; i++) {
	    System.out.println(defaults[i][0] +
			"(" + defaults[i][1] + "): " +
			getParsedString(defaults[i][0]));
	}
	for (int i = 1; i < args.length; i++) {
	    System.out.println(args[i] +": " + getParsedString(args[i]));
	}
	   
    }
}
