/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.sys;

import java.util.Vector;
import java.util.Enumeration;
import dejava.util.Changes;
import dejava.lang.*;

public final class HeaderManager extends MethodManager {
    public static final String HEADER_NAME = "*header*";
    static final MethodSpec HEADER_SPEC = new MethodSpec(HEADER_NAME);

    public HeaderManager(Manager parent) {
	super(parent, HEADER_SPEC);
    }

    public int lineOffset(int line) {
	return sourceFileManager().headerLineOffset(line);
    }

    public void changed(Changes chg) {
	//chg.setPrevious(sourceFileManager().header());
	sourceFileManager().header(chg);
	changed();
    }

    public boolean isChanged() {
	return sourceFileManager().header().isChanged();
    }

    protected String getCodeInternal() throws DejavaException {
	return sourceFileManager().headerCode();
    }

    public Manager setCode(String newCode)
    throws DescriptionException {
	CodeReader reader = new CodeReader(newCode);
	int nest;
	boolean found = false;
	while ((nest = reader.nextDescription()) == 0) {
	    String description = reader.description();
	    if (!description.startsWith("package ") &&
		!description.startsWith("import ")) {
		break;
	    }
	    found = true;
	}

	if (nest == -1) {
	    return changed(newCode);
	} else if (!found) {
	    // maybe ordinaly method description
	    return setCodeInternal(reader, newCode, nest);
	} else {
	    throw new DescriptionException("illegal header description");
	}
	    
    }

    void resolveImports(Vector imports, Vector imported) {
	StringBuffer code = new StringBuffer(getCode());
	boolean changed = false;
	Enumeration i = imports.elements();
	while (i.hasMoreElements()) {
	    ClassManager cm = (ClassManager)i.nextElement();
	    if (!imported.contains(cm) && !imported.contains(cm.parent())) {
		code.append("import " + cm.fullClassName() + ";\n");
		changed = true;
	    }
	}

	if (changed) {
	    changed(code.toString());
	}
    }

    Vector imported() {
	return sourceFileManager().imported();
    }

    /**
     * *header* should not be removed
     */
    public final Manager remove() {
	SystemManager.information("*header* should not be removed");
	return this;
    }

    /**
     * get package name described in the header part
     */
    public String packageName() {
	return sourceFileManager().headerPackageName();
    }
}
