/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh, Kazuhisa Shirakami
 */
package dejava.sys;

import java.util.*;

final class HierarchyEnumerator implements Enumeration {
    String methodName;
    ClassManager superClass;
    ClassManager classManager;
    CodePath codePath;

    /**
     * get hierarchy list of this class
     */
    public HierarchyEnumerator(ClassManager cm, String mn) {
	methodName = mn;
	classManager = cm;
	try {
	    superClass = cm.superClass();
	} catch (DejavaException e) {
	    superClass = null;
	}
	codePath = null;
    }

    public boolean hasMoreElements() {
	if (codePath != null) return true;
	codePath = null;
	for (;;) {
	    if (superClass == null) {
		if ("java.lang.Object".equals(classManager.fullClassName())) {
		    return false;
		}
		PackageManager pm = PackageManager.findPackage("java.lang");
		if (pm == null) return false;
		superClass = pm.findClass("Object");
		if (superClass == null) return false;
	    }
	    classManager = superClass;
	    try {
		superClass = classManager.superClass();
	    } catch (DejavaException e) {
		superClass = null;
	    }
	    if (methodName == null) {
		codePath = classManager.getCodePath();
		return true;
	    } else {
		try {
		    MethodManager mm = classManager.findMethod(methodName);
		    if (mm != null) {
			codePath = mm.getCodePath();
			return true;
		    }
		} catch (DejavaClassNotFoundException e) {
		}
	    }
	}
    }

    public Object nextElement() {
	if (codePath == null && !hasMoreElements()) {
	    return null;
	}
	CodePath cp = codePath;
	codePath = null;
	return cp;
    }

    public String toString() {
	return getClass() +
	    "[class=" + classManager.name() +
	    ",superClass=" + (superClass == null ? "null" : superClass.name()) +
	    ",hasMoreElements=" + (codePath == null ? "false" : "true") +
	    ",nextElement=" + (codePath == null ? "null" : codePath.toString()) +
	    "]";
    }
}
