/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.sys;

import java.io.File;

/**
 * abstract class for path based managers
 */
abstract class PathedManager extends Manager {
    /**
     * the relative path for this Manager
     */
    String path;

    /**
     * the file object
     */
    File file;

    /**
     * when the file is modified
     */
    //long lastModified = -1;

    protected PathedManager(Manager parent, String name, String path) {
	super(parent, name);
	this.path = path;
	this.file = null;
    }

    /**
     * set new path
     */
    protected void setPath(String newPath) {
	path = newPath;
	file = null;
    }

    /**
     * get relative pathname
     */
    public String path() {
	return path;
    }

    /**
     * get absolute pathname
     */
    public String absolutePath() {
	if (parent != null && parent instanceof PathedManager) {
	    return ((PathedManager)parent).absolutePath() + File.separator + path;
	} else {
	    return path;
	}
    }

    /**
     * get File object
     */
    public File file() {
	if (file == null) {
	    file = new DejavaFile(absolutePath());
	}
	return file;
    }

    /**
     * get File object
     */
    public File directory() {
	if (file().isDirectory()) {
	    return file();
	} else {
	    return new File(file().getParent());
	}
    }

    /**
     * dispose me
     */
    protected void dispose() {
	if (path != null) {
	    path = null;
	}
	if (file != null) {
	    file = null;
	}
	super.dispose();
    }
}
