/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.util;

import dejava.sys.*;
import java.io.File;
import java.util.Enumeration;

import dejava.util.SourceCodeRange;
import dejava.util.ListItem;

public class Changes extends SourceCodeRange implements ListItem {
    public static final String ACTION_CHANGED = "! ";
    public static final String ACTION_REMOVED = "- ";
    public static final String ACTION_RENAMED = "= ";
    public static final String ACTION_CREATED = "+ ";
    public static final String ACTION_VERSION = "% ";

    /* hold String or CodePath */
    Object codePath;
    ChangeList changes;
    String action;
    String date;
    Changes next;
    boolean isMarked = false;
    boolean isSynced = false;

    private final static int cursor[] = new int[2];
    static {
	cursor[0] = 0;
	cursor[1] = 0;
    }

    public ListItem cloneItem() {
	return new Changes(this);
    }

    public CodePath codePath() {
	if (!(codePath instanceof CodePath)) {
	    String names[] = CodePath.pathToNames((String)codePath);
	    CodePath cp = new CodePath(names);

	    if (cp.packageManager() == null) {
		PackageManager pkgMan =
			PackageManager.findPackage(names[CodePath.PACKAGE]);
		if (pkgMan == null) {	// no package found. should create one?
		    String msg = "Which project should package " +
				    names[CodePath.PACKAGE] +
				 " go into?";
		    String projName = names[CodePath.PROJECT];
		    projName = SystemManager.request(msg, projName);
		    if (projName == null) return CodePath.nullCodePath;
		    if (cp.projectManager(SystemManager.findProject(projName))
				== null) {
			SystemManager.information(
				"Project " + projName + " does not exist. " +
				"Create it before refering '" + codePath + "'.");
			return CodePath.nullCodePath;
		    }
		}
		cp.packageManager(pkgMan);
	    }

	    if (cp.classManager() == null) {
		String msg = "Class " + names[CodePath.CLASS] + " does not exist. " +
			      "Create it?";
		if (SystemManager.confirm(msg)) {
	    	    String fname = names[CodePath.CLASS] + ".java";
		    fname = SystemManager.requestFileName(
				"What is the filename for the class " + names[CodePath.CLASS] + "?",
				cp.packageManager().absolutePath(), fname);
		    SourceFileManager sfm =
			cp.packageManager().findSource(fname);
		    if (sfm == null) {
			sfm = cp.packageManager().createSourceFileManager(fname);
		    }
		    ClassManager cm = new ClassManager(sfm, names[CodePath.CLASS]);
		    sfm.addChild(cm);
		    cp.classManager(cm);
		} else {
		    SystemManager.information("Aborting reference to: " + codePath);
		    return CodePath.nullCodePath;
		}
	    }
	    codePath = cp;
	}
	return (CodePath)codePath;
    }

    /**
     * get change list
     */
    ChangeList changes() {
	return (changes != null) ?
		changes : codePath().projectManager().changes();
    }

    /**
     * set change list
     */
    void changes(ChangeList changes) {
	this.changes = changes;
    }

    /**
     * get code for this changes
     */
    public String getCode() {
	return changes().getCode(this);
    }

    /**
     * get code for this changes
     */
    public String getCode(File dummy) {
	return getCode();
    }

    /**
     * update the code
     */
    void update() {
	codePath().getManager().sync();
    }

    /**
     * construct new changes item
     */
    Changes(CodePath cp, String date, int start, int end) {
	this(cp, Changes.ACTION_CHANGED, date, start, end);
    }

    /**
     * construct new changes item
     */
    Changes(CodePath cp, String action, String date, int start, int end) {
	super(start, end);
	this.action = action;
	this.date = date;
	codePath = cp;
    }

    /**
     * construct new changes item
     */
    Changes(String cp, String action, String date, int start, int end) {
	super(start, end);
	this.action = action;
	this.date = date;
	codePath = new CodePath(cp);
	if (!((CodePath)codePath).printString().equals(cp)) {
	    codePath = cp;
	}
    }

    Changes(Changes clone) {
	super(clone);
	if (clone.codePath instanceof CodePath) {
	    codePath = new CodePath((CodePath)clone.codePath);
	} else {
	    codePath = clone.codePath;
	}
	changes  = clone.changes;
	action   = clone.action;
	date     = clone.date;
	next     = clone.next;
	isMarked = clone.isMarked;
	isSynced = clone.isSynced;
    }

    public String action() {
	return action;
    }

    public String date() {
	return date;
    }

    public int cursorPos()[] {
	return cursor;
    }

    public String listString() {
	if (codePath instanceof CodePath) {
	    return date + " " + action + codePath().printString();
	} else {
	    return date + " " + action + codePath;
	}
    }

    public boolean isMarked() {
	return isMarked;
    }

    public boolean isSameCode(ListItem with) {
	return this.equals(with);
    }

    public boolean isChanged() {
	return true;
    }

    public void setMark(boolean marked) {
	isMarked = marked;
    }

    public void synced() {
	isSynced = true;
    }

    public void dispose() {
	codePath = null;
	changes = null;
	action = null;
	date = null;
	next = null;
    }
}
