/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.util;

import dejava.sys.*;
import dejava.lang.*;
import dejava.gui.DejavaFrame;
import java.lang.*;
import java.util.*;
import java.io.*;

public class CodeLocation implements ListItem {

    CodePath codePath;
    private String listString;
    private int lineNumber;
    private int cursorOffset;
    private int cursorLength;

    boolean isMarked = false;

    public CodeLocation(String fname, int line, String item)
						throws CodeLocationException {
        this(fname, line, item, 0, -1);
    }

    public CodeLocation(String fname, int line, String item,
		        int offset, int length) throws CodeLocationException {
	listString  = item;
	cursorOffset = offset;
	cursorLength = length;

	SourceFileManager sourceFileManager =
			SourceFileManager.findSourceFileManagerForFile(fname);
	try {
	    codePath = searchCodePath(sourceFileManager, line);
	} catch (DejavaException e) {
	    codePath = null;
	}
	if (codePath == null) throw new CodeLocationException();
    }

    public CodeLocation(CodePath cp, String fname, int line, String item,
			int offset, int length) throws CodeLocationException {
	listString = item;
	cursorOffset = offset;
	cursorLength = length;

	PackageManager packageManager = cp.packageManager();
	if (packageManager != null) {
	    SourceFileManager sourceFileManager = packageManager.findSource(fname);
	    try {
		codePath = searchCodePath(sourceFileManager, line);
		if (codePath != null) return;
	    } catch (DejavaException e) {
	    }
	}
	    
	ProjectManager projectManager = cp.projectManager();
	if (projectManager != null) {
	    Enumeration packages = projectManager.packages();
	    while (packages.hasMoreElements()) {
		SourceFileManager sourceFileManager =
		    ((PackageManager)packages.nextElement()).findSource(fname);
		try {
		    codePath = searchCodePath(sourceFileManager, line);
		    if (codePath != null) return;
		} catch (DejavaException e) {
		}
	    }
	}

	SourceFileManager sourceFileManager =
			SourceFileManager.findSourceFileManagerForFile(fname);
	try {
	    codePath = searchCodePath(sourceFileManager, line);
	} catch (DejavaException e) {
	    codePath = null;
	}
	if (codePath == null) throw new CodeLocationException();
    }

    public CodeLocation(CodeLocation clone) {
	codePath     = new CodePath(clone.codePath);
	listString   = clone.listString;
	lineNumber   = clone.lineNumber;
	cursorOffset = clone.cursorOffset;
	cursorLength = clone.cursorLength;
	isMarked     = clone.isMarked;
    }

    public ListItem cloneItem() {
	return new CodeLocation(this);
    }

    private CodePath searchCodePath(SourceFileManager sourceFileManager, int line) throws DejavaException {
	if (sourceFileManager == null) return null;
	lineNumber = 0;
	Enumeration classes = sourceFileManager.classes();
	while (classes.hasMoreElements()) {
	    ClassManager classManager = (ClassManager)classes.nextElement();
	    if ((lineNumber = classManager.lineOffset(line)) <= line) {
		    Enumeration methods = classManager.methods();
		    while (methods.hasMoreElements()) {
			MethodManager methodManager = (MethodManager)methods.nextElement();
			int lineOffset;
			if ((lineOffset = methodManager.lineOffset(line)) >= 0) {
			    lineNumber = lineOffset;
			    return new CodePath(methodManager);
			}
		    }
		return new CodePath(classManager);
	    }
	}
	return new CodePath(sourceFileManager);
    }

    public CodePath codePath() {
	return codePath;
    }

    public String listString() {
	return listString;
    }

    public int cursorPos()[] {
	String code;
	int cursor[] = new int[2];
	cursor[0] = 0;
	cursor[1] = 0;
	if (codePath == null) return cursor;
	code = codePath.getManager().getCode();

	int pos = 0;
	for (int line = lineNumber; line > 0; line--) {
	    pos = code.indexOf('\n', pos) + 1;
	    if (pos <= 0) return cursor;
	}

	cursor[0] = pos + cursorOffset;
	if (cursorLength >= 0) {
	    cursor[1] = cursor[0] + cursorLength;
	} else {
	    cursor[1] = code.indexOf('\n', cursor[0]) + 1;
	    if (cursor[1] <= 0) cursor[1] = code.length();
	}
	return cursor;
    }

    public boolean isMarked() {
	return isMarked;
    }

    public boolean isChanged() {
	return true;
    }

    public boolean isSameCode(ListItem item) {
	return codePath().matches(item.codePath());
    }

    public void setMark(boolean marked) {
	isMarked = marked;
    }
}
