/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.util;

import java.io.*;
import dejava.sys.SystemManager;

public class Command implements Runnable {
    private String command[] = new String[3];
    private Process process = null;

    /**
     * caller->(outForCaller)->(inFromCaller)->this(callerToCommandThread)
     *						 ->(outToCommand )->command
     * caller<-(inForCaller )<-(outToCaller )<-this(commandToCallerThread)
     *						 <- (inFromCommand)<-command
     * But, not yet implemented caller to command path.
     */
    private Thread commandToCallerThread = null;
    private PipedInputStream inForCaller   = null;
    private PrintStream      outToCaller   = null;
    private DataInputStream  inFromCommand = null;

    private static String shell;
    private static String shellOption;
    private protected static boolean useOriginalShell = false;
    static {
	if (SystemManager.onWin32) {
	    shell = SystemManager.DEJAVABIN + "dash.exe";
	    if (new File(shell).exists()) {
		useOriginalShell = true;
	    } else if (SystemManager.onWinNT) {
		shell = "cmd.exe";
	    } else {
		shell = "command.com";
	    }
	    shellOption = "/C";
	} else {
	    shell = "/bin/sh";
	    shellOption = "-c";
	}
    }

    protected void setCommand(String cmd[]) {
	if (cmd == null || cmd.length == 0) return;
	StringBuffer join = new StringBuffer(cmd[0]);
	for (int i = 1; i < cmd.length; i++) {
	    join.append(' ').append(cmd[i]);
	}
	setCommand(join.toString());
    }

    protected void setCommand(String cmd) {
	if (cmd == null || cmd.length() == 0) return;
	command[0] = shell;
	command[1] = shellOption;
	if (SystemManager.onWin32) {
	    if (useOriginalShell) {
		int escape = cmd.length();
		escape = cmd.length();
		while ((escape = cmd.lastIndexOf('"', escape - 1)) >= 0) {
		    cmd = cmd.substring(0, escape) + "\\" + cmd.substring(escape);
		}
	    }
	    command[2] = cmd;
	} else {
	    command[2] = cmd + " 2>&1";
	}
    }

    public void run() {
	if (Thread.currentThread() == commandToCallerThread) {
	    String data;
	    boolean hasMessage = false;
	    long start = System.currentTimeMillis();
	    try {
		while (commandToCallerThread != null) {
		   data = inFromCommand.readLine();
		   if (data == null) break;
		   outToCaller.println(data);
		   hasMessage = true;
		}
	    } catch (IOException e) {
		long end = System.currentTimeMillis();
		if (!hasMessage && process.exitValue() == 0 && start + 1000 > end) {
		    SystemManager.information("maybe failed to execute, try again, sorry");
		}
	    } finally {
		/*try {
		    process.waitFor();
		} catch (InterruptedException e) {
		}*/
		process.destroy();
		try {
		    outToCaller.close();
		    inFromCommand.close();
		} catch (IOException e) {
		}
		outToCaller = null;
		inFromCommand = null;
		process = null;
	    }
	}
    }

    public synchronized void exec() throws IOException {
	process = Runtime.getRuntime().exec(command);
	inFromCommand = new DataInputStream(process.getInputStream());
    }

    public synchronized void stop() {
	if (commandToCallerThread != null) commandToCallerThread = null;
    }

    public InputStream getInputStream() throws IOException {
	if (process == null) return null;
	PipedInputStream inForCaller = new PipedInputStream();
	outToCaller = new PrintStream(new PipedOutputStream(inForCaller));
	commandToCallerThread = new Thread(this);
	commandToCallerThread.start();
	return inForCaller;
    }
}
