/*
 * Copyright (c) 1995 PFU Limited.
 *      author Kazuhisa Shirakami
 */
package dejava.util;

import dejava.sys.*;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.Enumeration;

import dejava.util.Command;

public class Compile extends Command {
    private static String javac = System.getProperty("java.home") +
				  File.separator + "bin" +
				  File.separator + "javac";
    public static boolean canExecute = false;

    String fileNames;

    static {
	if (SystemManager.onWin32) {
	    javac += ".exe";
	}
        File file = new File(javac);
        if (file.exists()) canExecute = true;
    }

    public Compile(CodePath cp, boolean updated) {
	super();
        Vector args = new Vector();
        StringBuffer files = new StringBuffer();
        String classPath;
        if (cp.sourceFileManager() != null) {
            classPath = cp.sourceFileManager().getClassPath();
            String file = cp.sourceFileManager().absolutePath();
            args.addElement(file);
            files.append(file);
        } else {
            classPath = cp.projectManager().absolutePath() +
			SystemManager.PATHSEPARATOR +
			cp.packageManager().absolutePath();
            PackageManager pm = cp.packageManager();
            Enumeration en = pm.sources();
            while (en.hasMoreElements()) {
		SourceFileManager sfm = (SourceFileManager)en.nextElement();
		if (updated && !sfm.isUpdatedAfterLastCompilation()) continue;
                String file = sfm.absolutePath();
                args.addElement(file);
                files.append("\n").append(file);
            }
	    if ((SystemManager.onWin32) && !useOriginalShell &&
		files.toString().length() > 255) {
		args.setSize(0);
		files.setLength(0);
		if (updated) files.append("\nToo many files, compile all files, sorry.");
		String fname = pm.absolutePath() + File.separator + "*.java";
		args.addElement(fname);
		files.append("\n").append(fname);
	    }
        }
        fileNames = files.toString();
        String command[] = new String[1 + args.size()];
	if (SystemManager.onSolaris) {
	    command[0] = "CLASSPATH=" + SystemManager.CLASSPATH +
					SystemManager.PATHSEPARATOR +
					classPath + " " +
					javac;
	} else {
	    command[0] = javac;
	}
        int i = 1;
        Enumeration en = args.elements();
        while (en.hasMoreElements()) {
            command[i++] = (String)en.nextElement();
        }
        setCommand(command);
    }

    public String fileNames() {
	return fileNames;
    }
}
