/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.util;

import dejava.sys.SystemManager;
import java.io.*;

public class Execute implements Runnable {

    Command command;
    DataInputStream messages = null;
    private String name;

    public Execute(String nm, String cmd) {
	name = "execute " + nm + ": ";
	command = new Command();
	command.setCommand(cmd);
    }

    public void run() {
	SystemManager.message(name + "started.\n");
	String terminated;
	try {
	    String message;
	    while ((message = messages.readLine()) != null) {
		SystemManager.messageln(message);
	    }
	    terminated = ".";
	} catch (IOException e) {
	    terminated = " by I/O error.";
	}
	SystemManager.messageln(name + "terminated" + terminated);
	command.stop();
    }

    public void start() {
	try {
	    command.exec();
	    messages = new DataInputStream(command.getInputStream());
	    (new Thread(this)).start();
	} catch (IOException e) {
	    SystemManager.message(name + "fail to execute.\n");
	}
    }
}
