/*
 * Copyright (c) 1995 PFU Limited.
 *      author Kazuhisa Shirakami
 */
package dejava.util;

import dejava.sys.*;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;

import dejava.util.Command;

public class Grep extends Command {
    private static boolean initialized = false;
    private static String grep[];
    private static int patternIndex;
    public static String separator;
    public static char separatorChar;
    private static String quote;
    public static boolean canExecute = true;

    String command[];
    private String pattern;

/*
    static {
	File file = new File(grep);
	if (file.exists()) canExecute = true;
    }
*/

    public Grep(CodePath cp, String pattern) throws DejavaException {
	super();
	if (!initialized) {
	    initialize();
	    initialized = true;
	}
        ProjectManager prj;
        PackageManager pkg;
        Vector files = new Vector();
        if (cp.classManager() != null) {
            String fname = cp.sourceFileManager().absolutePath();
            files.addElement(fname);
        } else if ((pkg = cp.packageManager()) != null) {
	    addFiles(files, pkg);
        } else if ((prj = cp.projectManager()) != null) {
	    addFiles(files, prj);
        } else {
            Enumeration projs = SystemManager.allProjects();
            while (projs.hasMoreElements()) {
		addFiles(files, (ProjectManager)projs.nextElement());
	    }
        }
        int size = files.size();
        command = new String[grep.length + size];
	for (int i = 0; i < grep.length; i++) {
	    command[i] = grep[i];
	}
	if (separator == null) {
	    for (int i = 0; i < size; i++) {
		command[grep.length + i] = (String)files.elementAt(i);
	    }
	} else {
	    for (int i = 0; i < size; i++) {
		String f = (String)files.elementAt(i);
		command[grep.length + i] =
				f.replace(File.separatorChar, separatorChar);
	    }
	}
	setPattern(pattern);
    }

    void initialize() throws DejavaException {
	String command   = DejavaProperties.getString("command.grep");
	separator = DejavaProperties.getString("command.grep.separator");
	quote     = DejavaProperties.getString("command.grep.quote");
	if (SystemManager.onWin32) {
	    if (command   == null) command = "egrep -n -e %pattern% nul";
	    if (separator == null) separator = "/";
	    if (quote     == null) quote = "\"";
	} else {
	    if (command   == null) command = "egrep -n -e %pattern% /dev/null";
	    if (separator == null) separator = "/";
	    if (quote     == null) quote = "'";
	}
	separatorChar = separator.charAt(0);
	if (separatorChar == File.separatorChar) separator = null;
	patternIndex = -1;
	StringTokenizer st = new StringTokenizer(command);
	grep = new String[st.countTokens()];
	for (int i = 0; i < grep.length; i++) {
	    grep[i] = st.nextToken();
	    if ("%pattern%".equals(grep[i])) {
		patternIndex = i;
	    }
	}
	if (patternIndex < 0) {
	    new DejavaException("\"%pattern%\" parameter nothing in command.grep property");
	}
    }

    private static void addFiles(Vector files, PackageManager pkg) {
	if (SystemManager.onWin32) {
	    files.addElement(pkg.absolutePath() + File.separator + "*.java");
	} else {
	    Enumeration srcs = pkg.sources();
	    while (srcs.hasMoreElements()) {
		String fname = ((SourceFileManager)srcs.nextElement()).absolutePath();
		files.addElement(fname);
	    }
	}
    }

    private static void addFiles(Vector files, ProjectManager prj) {
	Enumeration pkgs = prj.packages();
	while (pkgs.hasMoreElements()) {
	    addFiles(files, (PackageManager)pkgs.nextElement());
	}
    }

    public void setPattern(String newPattern) {
	command[patternIndex] = quote + newPattern + quote;
	setCommand(command);
	pattern = newPattern;
    }

    public String pattern() {
	return pattern;
    }
}
