/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.util;

import dejava.sys.*;
import java.io.*;

public class SourceCodeRange {
    protected int startPoint;
    protected int endPoint;
    protected int startLine;
    protected int endLine;

    public SourceCodeRange(int startPoint, int endPoint, int startLine, int endLine) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public SourceCodeRange(int startPoint, int endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;

        // line numbers are unknown
        this.startLine = -1;
        this.endLine = -1;
    }

     SourceCodeRange(SourceCodeRange clone) {
	startPoint = clone.startPoint;
	endPoint   = clone.endPoint;
	startLine  = clone.startLine;
	endLine    = clone.endLine;
    }

    public int startPoint() {
        return startPoint;
    }

    public int endPoint() {
        return endPoint;
    }

    public int startLine() {
        return startLine;
    }

    public int endLine() {
        return endLine;
    }

    public int length() {
        return endPoint - startPoint;
    }

    public int lines() {
        return endLine - startLine;
    }

    public String getCode(File sourceFile) {
	try {
	    RandomAccessFile raf = new RandomAccessFile(sourceFile, "r");
	    raf.seek(startPoint);
	    byte buf[] = new byte[endPoint - startPoint];
	    raf.read(buf);
	    raf.close();
	    return new String(buf, 0);
	} catch (java.io.IOException e) {
	   SystemManager.exception("Could not get code. Sorry.", e);
	   return "/* COULD NOT GET CODE */";
	}
    }

    public boolean isSynced() {
	return true;
    }

    public boolean isChanged() {
	return false;
    }

    public void synced() {}

    public void dispose() {}
}
