/*
 * Copyright (c) 1995 PFU Limited.
 *	author Kazuhisa Shirakami
 */
package dejava.util;

import java.util.Enumeration;
import java.util.Vector;

public class StringSorter extends Vector {
    private final static boolean UNIQ = true;
    private final static boolean NOUNIQ = false;

    private void addElementAndSort(String item, boolean uniq) {
	int min = 0;
	int max = elementCount;
	int pos = elementCount / 2;

	while (min != max) {
	    int comp = item.compareTo((String)elementAt(pos));
	    if (comp == 0) {
		if (uniq) return;
		break;	// match
	    } else if (comp < 0) {
		max = pos;
	    } else {
		min = pos + 1;
	    }
	    pos = (min + max) / 2;
	}
	if (pos == elementCount) {
	    addElement(item);
	} else {
	    insertElementAt(item, pos);
	}
    }

    public void addElementAndSort(String item) {
	addElementAndSort(item, NOUNIQ);
    }

    public void addElementAndSortUniq(String item) {
	addElementAndSort(item, UNIQ);
    }

    public static String sort(String strings[])[] {

	if (strings == null) return null;

	StringSorter sorter = new StringSorter();
	for (int i = strings.length; --i >= 0; ) {
	   sorter.addElementAndSort(strings[i]);
	}

	String sorted[] = new String[strings.length];
	for (int i = strings.length; --i >= 0; ) {
	   sorted[i] = (String)sorter.elementAt(i);
	}

	return sorted;
    }

    public static Vector sort(Vector strings) {
	StringSorter sorter = new StringSorter();
	Enumeration en = strings.elements();
	while (en.hasMoreElements()) {
	   Object obj = en.nextElement();
	   if (obj instanceof String) {
		sorter.addElementAndSort((String)obj);
	   }
	}
	return sorter;
    }
}
