/*
 * Copyright (c) 1995 PFU Limited.
 *	author Osamu Satoh
 */
package dejava.util;

import java.io.File;

public final class StringSourceCode extends SourceCodeRange {
    String code;

    public StringSourceCode(String code) {
	super(0, code.length(), 1, 0);
	this.code = code;
	char chars[] = code.toCharArray();
	endLine = 1;
	for (int i = 0; i < chars.length; i++) {
	    if (chars[i] == '\n') {
		endLine++;
	    }
	}
    }

    public StringSourceCode(StringBuffer buf) {
	this(buf.toString());
    }

    public String getCode(File dummy) {
	return code;
    }
}
