-- This file is part of SystemTestPortal.
-- Copyright (C) 2017  Institute of Software Technology, University of Stuttgart
--
-- SystemTestPortal is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- SystemTestPortal is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with SystemTestPortal.  If not, see <http://www.gnu.org/licenses/>.

-- +migrate Up
ALTER TABLE users ADD COLUMN image VARCHAR;

-- +migrate Down
ALTER TABLE users RENAME TO users_old;
CREATE TABLE users (
    id INTEGER PRIMARY KEY REFERENCES owners(id),
    name VARCHAR(255) NOT NULL UNIQUE,
    display_name VARCHAR(255),
    email VARCHAR(255),
    password_hash CHAR NOT NULL,
    registration_date TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
    is_admin BIT(1) NOT NULL DEFAULT(0),
    biography VARCHAR(255),
    is_shown_public BIT(1) NOT NULL DEFAULT(1),
    is_email_public BIT(1) NOT NULL DEFAULT(0)
);
INSERT INTO users SELECT id, name, display_name, email, password_hash, registration_date, is_admin, biography, is_shown_public, is_email_public FROM users_old;
DROP TABLE users_old;