$.getScript("/static/js/util/common.js");
$.getScript("/static/js/util/ajax.js");

/* Button Assignment */
//List
$("#buttonNewTestCase")      .click(newTestCase);
$("#buttonFirstTestCase")    .click(newTestCase);
$("#buttonNewLabel")         .click(function(event) { /* nothing yet */});
$(".testCaseLine")           .click(showTestCase);
//Show
$("#buttonBack")             .click(backToTestCaseList);
$("#buttonDeleteConfirmed")  .click(deleteTestCase);
$("#buttonEdit")             .click(editTestCase);
$("#buttonHistory")          .click(showTestCaseHistory);
//$("#buttonRevertConfirmed").click(function () { revertTestCase);
//History
$("#buttonBackToCase")       .click(backToTestCase);
$(".versionLine")            .click(showTestCaseVersion);
//New
$("#buttonAbort")            .click(backToTestCaseList);
$("#buttonSaveNew")          .click(saveTestCase);
//Edit
$("#buttonSave")             .click(updateTestCase);
$("#buttonAbortEdit")        .click(backToTestCase);

/* AJAX-Functions */
/* loads the new test case form */
function newTestCase(event) {
    ajaxRequestFragment(event, "new", "", "GET");
}

/* loads the chosen test case */
function showTestCase(event) {
    ajaxRequestFragment(event, event.target.id, "", "GET");
}

/* loads the chosen test case version*/
function showTestCaseVersion(event) {
    var url = urlify(window.location.pathname).takeFirstSegments(5).toString();
    // Get version number. When clicking on an element that is in the .versionLine, check the parent of
    // this element until the parent is the versionLine with the id
    var ind = event.target.id;
    while (ind === "") {
        event.target = event.target.parentNode;
        ind = event.target.id;
    }
    ajaxRequestFragment(event, url + "?version=" + ind, "", "GET");
}

/* saves the test case */
function saveTestCase(event) {
    ajaxRequestFragment(event, "save", getTestCaseData(), "POST");
}

/* saves the test case */
function updateTestCase(event) {
    $('#modal-testCase-save').on
    (
        'hidden.bs.modal',
        handleEdit(event, $('#minorUpdate').is(':checked'))
    ).modal('hide');
}

/* deletes a test case */
function deleteTestCase(event) {
    $('#deleteModal').on('hidden.bs.modal', function () {
        ajaxRequestFragment(event, window.location.pathname, null, "DELETE");
    }).modal('hide');
}

/* edits a test case */
function editTestCase(event) {
    var ver =$('#inputTestCaseVersion').find("option:selected").val();
    ajaxRequestFragment(event, window.location.pathname + "/edit", { version: ver }, "GET");
}

/* show test case history */
function showTestCaseHistory(event) {
    ajaxRequestFragment(event, window.location.pathname + "/history", "", "GET");
}

/* revert test case to selected version */
function revertTestCase(event) {
    // not yet implemented
}

/* steps back to the test case  */
function backToTestCase(event) {
    var requestURL = urlify(window.location.pathname).takeFirstSegments(5).toString();
    ajaxRequestFragment(event, requestURL, "", "GET");
}

/* steps back to the test case list */
function backToTestCaseList(event) {
    var requestURL = getProjectURL() + "/" + "testcases" + "/";
    ajaxRequestFragment(event, requestURL, "", "GET");
}

/* helper */

// getData returns an array with the test case information
function getTestCaseData() {
    return {
        inputTestCaseName: $('#inputTestCaseName').val(),
        inputTestCaseDescription: $('#inputTestCaseDescription').val(),
        inputTestCasePreconditions: $('#inputTestCasePreconditions').val(),
        inputTestCaseSUTVersionFrom: $('#inputTestCaseSUTVersionFrom').find("option:selected").val(),
        inputTestCaseSUTVersionTo: $('#inputTestCaseSUTVersionTo').find("option:selected").val(),
        inputHours: getHours(),
        inputMinutes: getMinutes()
    }
}

// getDataEdit return an array with information of the test case to edit
function getTestCaseDataEdit(isMinor) {
    return {
        isMinor: isMinor,
        inputCommitMessage: $('#inputCommitMessage').val(),
        inputTestCaseName: $('#inputTestCaseName').val(),
        inputTestCaseDescription: $('#inputTestCaseDescription').val(),
        inputTestCasePreconditions: $('#inputTestCasePreconditions').val(),
        inputTestCaseSUTVersionFrom: $('#inputTestCaseSUTVersionFrom').find("option:selected").val(),
        inputTestCaseSUTVersionTo: $('#inputTestCaseSUTVersionTo').find("option:selected").val(),
        inputHours: getHours(),
        inputMinutes: getMinutes()
    }
}

// handleEdit either updates the current version or saves the edited version as newest version, depending
// on the handling parameter
function handleEdit(event, isMinor) {
    event.preventDefault();

    var url = urlify(window.location.pathname).removeLastSegments(1);

    var posting = $.ajax({
        url: url.appendSegment("update?fragment=true").toString(),
        type: "PUT",
        data: getTestCaseDataEdit(isMinor)
    });
    posting.done(function(response) {
        var historyText = urlify(window.location.pathname).takeFirstSegments(4).toString();
        historyText = historyText + "/" + posting.getResponseHeader("newName");
        $('#tabTestCases').empty().append(response);
        history.pushState('data', '', historyText);
    }).fail(function (response) {
        $( "#modalPlaceholder" ).empty().append(response.responseText);
        $('#errorModal').modal('show');
    });
}

// getHours returns 0 if no hours duration was given
function getHours() {
    var hours = parseInt($('#inputHours').val());
    if (isNaN(hours)) {
        return 0;
    }
    return hours;
}

// getMinutes returns 0 if no minutes duration was given
function getMinutes() {
    var mins = parseInt($('#inputMinutes').val());
    if (isNaN(mins)) {
        return 0;
    }
    return mins;
}

// 2562047 is the max of int64 as nanoseconds converted to minutes
var HOUR_HARD_LIMIT = 2562047;

// checkMinutes sets the minutes between 0 and 59
function checkMins(form) {
    minutes = Math.min(Math.max(0, form.value), 59);
}

// checkHour sets the input between 0 and the biggest number that can be shown
// by a test case
function checkHours(form) {
    hours = Math.min(Math.max(0, form.value), HOUR_HARD_LIMIT);
}

var hours = getHours();
var minutes = getMinutes();

$("#hour-plus").click(function () {
    if (hours < HOUR_HARD_LIMIT) {
        hours++;
        $("#inputHours").val(hours);
    }
});
$("#hour-minus").click(function () {
    hours = Math.min(0, hours - 1);
    $("#inputHours").val(hours);
});
$("#minute-plus").click(function () {
    minutes = (minutes + 1) % 60;
    if (minutes === 0) {
        hours++;
        $("#inputHours").val(hours);
    }
    $("#inputMinutes").val(minutes);
});
$("#minute-minus").click(function () {
    if (minutes <= 0 && hours > 0) {
        hours--;
        minutes = 59;
        $("#inputHours").val(hours);
    } else if (minutes <= 0) {
        minutes = 0;
    } else {
        minutes--;
    }
    $("#inputMinutes").val(minutes);
});