/* Ajax requests */

function ajaxRequestFragment (event, target, params, requestType) {
    ajaxRequestFragmentWithHistory (event, target, params, requestType, target);
}

function ajaxRequestFragmentWithHistory (event, target, params, requestType, historyText) {
    event.preventDefault();
    target = updateQueryStringParameter(target, "fragment", true);

    var posting = $.ajax({
        url: target,
        type: requestType,
        data: params
    });
    posting.done(function(response) {
        history.pushState('data', '', historyText);
        $('#tabarea').empty().append(response);
        return true;
    }).fail(function (response) {
        $( "#modalPlaceholder" ).empty().append(response.responseText);
        $('#errorModal').modal('show');
    });
}

function updateQueryStringParameter(uri, key, value) {
    var regex = new RegExp("([?&])" + key + "=.*?(&|#|$)", "i");
    if (uri.match(regex)) {
        return uri.replace(regex, '$1' + key + "=" + value + '$2');
    } else {
        var hash =  '';
        var index = uri.lastIndexOf('#');
        if( index !== -1 ){
            hash = uri.slice(index, uri.length);
            uri = uri.slice(0, index);
        }
        var separator = uri.indexOf('?') !== -1 ? "&" : "?";
        return uri + separator + key + "=" + value + hash;
    }
}