
/* attach a handler to the form submit button */
$("#login").submit(function(event) {

    /* stop form from submitting normally */
    event.preventDefault();

    /* get the action attribute from the <form action=""> element */
    var $form = $( this );
    var url = $form.attr( 'action' );

    /* Send login request */
    var posting = $.post( url, {
        inputPassword: $('#inputPassword').val(),
        inputIdentifier: $('#inputEmail').val()
    } );

    posting.done(function () {
        $('#login-modal').modal('hide');
        location.reload();
    }).fail(function (response) {
        if (response.status >= 500) {
            $('#login-modal').modal('hide');
            $( "#modalPlaceholder" ).empty().append(response.responseText);
            $('#errorModal').modal('show');
        } else {
            $('#passwordFeedback').text(response.responseText);
            $('#formEmail').addClass('has-danger');
            $('#formPassword').addClass('has-danger');
        }
    });
});

// Clears errors when login modal is closed
$('#login-modal').on('hidden.bs.modal', function () {
    clearErrors()
});

// Clears errors displayed in the login modal
function clearErrors() {
    $('#passwordFeedback').text("");
    $('#formEmail').removeClass('has-danger');
    $('#formPassword').removeClass('has-danger');
}