

function getProjectURL() {
    return urlify(window.location.pathname).takeFirstSegments(3).toString();
}

function urlify(string) {
    return new URL(string.split("/"));
}

function URL(seg) {
    this.segments = seg;
    this.toString = function () {
        return this.segments.join("/")
    };
    this.removeLastSegments = function(n) {
        var copy = new URL(this.segments);
        copy.segments = copy.segments.slice(0, this.segments.length - n);
        return copy;
    };
    this.takeFirstSegments = function(n) {
        var copy = new URL(this.segments);
        copy.segments = copy.segments.slice(0, n);
        return copy;
    };
    this.appendSegment = function(s) {
        var copy = new URL(this.segments);
        copy.segments.push(s);
        return copy;
    };
}