

/* attach a handler to the add test cases form submit button */
$("#buttonAddTestCases").click(function() {
    var testcases = "";
    $(".testCaseInTestSequence").each(function () {
        testcases = testcases + this.id + "~";
    });
    $(".testCaseSelector").each(function () {
        if(this.checked) {
            if(document.getElementById("testCaseListPlaceholder")) {
                $("#testCaseListPlaceholder").remove();
            }
            $( "#testCasesList" ).append("" +
                "<li id=\""+this.id+"\" class=\"list-group-item testCaseInTestSequence\">" +
                "   <span>"+this.name+"</span>" +
                "   <button type=\"button\" class=\"remove-test-case close ml-auto\" aria-label=\"Remove\">" +
                "       <span aria-hidden=\"true\">&times;</span>" +
                "   </button>" +
                "</li>");
            testcases = testcases + this.id + "~";
        }
    });

    $('#modal-testcase-selection').modal('hide');
    refreshTestsequence(testcases);
});

$(document).on('click', '.remove-test-case', function() {
    if($(this).parent().parent().children().length < 2) {
        $(this).parent().parent().append("" +
            "<li class=\"list-group-item\" id=\"testCaseListPlaceholder\">" +
            "   <span class=\"text-muted\">No Test Cases</span>" +
            "   <button type=\"button\" class=\"add-test-case close ml-auto\" aria-label=\"Add Test Case\" " +
            "           data-toggle=\"modal\" data-target=\"#modal-testcase-selection\">" +
            "       <span aria-hidden=\"true\">+</span>" +
            "   </button>" +
            "</li>");
    }
    $(this).parent().remove();

    var testcases = "";
    $(".testCaseInTestSequence").each(function () {
        testcases = testcases + this.id + "~";
    });
    refreshTestsequence(testcases);
});

$('#modal-testcase-selection').on('show.bs.modal', function () {
    $(".testCaseSelector").each(function () {
        if(this.checked) {
            this.checked = false;
        }
        if($("#testCasesList").has('#'+this.id).length > 0) {
            $(this).parent().parent().addClass("d-none");
        } else {
            $(this).parent().parent().removeClass("d-none");
        }
    });
    if( $("#testcase-selection").find("> div ").not('.d-none').length > 0) {
        $("#testCaseSelectorPlaceholder").addClass("invisible");
    } else {
        $("#testCaseSelectorPlaceholder").removeClass("invisible");
    }
});

/* updates the SUTVersions and Duration of the testsequence*/
function refreshTestsequence(cases) {

    var urlSeg = window.location.pathname.split("/");
    url = urlSeg[0] + "/" + urlSeg[1] + "/" + urlSeg[2] + "/" + urlSeg[3] + "/info";

    var posting = $.get(url, {
        newTestcases: cases
    });

    /* Alerts the results */
    posting.done(function (response) {
        var result = JSON.parse(response);
        var field = document.getElementById("testsequenceSUTVersionFrom");
        field.textContent = result.SUTVersionFrom;
        field = document.getElementById("testsequenceSUTVersionTo");
        field.textContent = result.SUTVersionTo;
        field = document.getElementById("testsequenceTime");
        var duration = "";

        if(result.DurationHours === 0 && result.DurationMin === 0){
            duration = "No Test Duration";
        } else {
            if(result.DurationHours > 0){
                if(result.DurationHours === 1){
                    duration = result.DurationHours + " Hour ";
                } else {
                    duration = result.DurationHours + " Hours ";
                }
            }
            if(result.DurationMin > 0){
                if(result.DurationMin === 1){
                    duration = duration + result.DurationMin+ " Minute ";
                } else {
                    duration = duration + result.DurationMin+ " Minutes ";
                }
            }
        }
        field.textContent = duration;
    }).fail(function (response) {
        $("#modalPlaceholder").empty().append(response.responseText);
        $('#errorModal').modal('show');
    });

}
