// testCaseVersionData contains the variants and versions of the test case
var testCaseVersionData = {};

// Listen to changes in the drop down menu of the variants
setVariantOnChangeListener();

function fillVariants(variants, selectorID) {
    $('#inputTestCaseSUTVariants').empty();
    $.each(variants, function (key, variant) {
        addVariant(variant, selectorID);
    });
}

function addVariant(variant, selectorID) {
    var selector = $(selectorID);
    var selectedValue = selector.val();
    selector.append($("<option></option>")
        .attr("value", variant.Name)
        .text(variant.Name));
    selector.value = selectedValue;
}


// Update the list with versions when selecting another variant
function setVariantOnChangeListener() {
    $('#inputTestCaseSUTVariants').on('change', function () {
        updateVersionShowList()
    });
}

/*
 * Updates the list with the versions
 */
function updateVersionShowList() {

    var variantKey = $('#inputTestCaseSUTVariants').val();
    var list = $('#inputTestCaseSUTVersions');
    // remove all previously shown elements
    list.empty();
    // add versions of selected variant to list
    $.each(testCaseVersionData[variantKey].Versions, function (key, version) {
        var listElement = ($("<li></li>")
            .attr("class", "list-item")
            .html('<span>' + version.Name + '</span>'));
        list.append(listElement)
    });


}

